/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.customcharts.core;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.customcharts.core.Messages;
import org.eclipse.swtchart.customcharts.internal.support.BarSeriesIon;
import org.eclipse.swtchart.customcharts.internal.support.BarSeriesIonComparator;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;

public class MassSpectrumChart
extends BarChart {
    private static final DecimalFormat DEFAULT_DECIMAL_FORMAT = new DecimalFormat();
    private int numberOfHighestIntensitiesToLabel;
    private BarSeriesIonComparator barSeriesIonComparator;
    private LabelOption labelOption;
    private Map<Double, String> customLabels;

    public MassSpectrumChart() {
        this.initialize();
    }

    public MassSpectrumChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setNumberOfHighestIntensitiesToLabel(int numberOfHighestIntensitiesToLabel) {
        this.numberOfHighestIntensitiesToLabel = numberOfHighestIntensitiesToLabel >= 0 ? numberOfHighestIntensitiesToLabel : 0;
    }

    public void setLabelOption(LabelOption labelOption) {
        this.labelOption = labelOption;
    }

    public void setCustomLabels(Map<Double, String> customLabels) {
        if (customLabels != null) {
            this.customLabels = customLabels;
        }
    }

    private void initialize() {
        this.numberOfHighestIntensitiesToLabel = 5;
        this.barSeriesIonComparator = new BarSeriesIonComparator();
        this.labelOption = LabelOption.EXACT;
        this.customLabels = new HashMap<Double, String>();
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(true);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroX(false);
        rangeRestriction.setZeroY(false);
        rangeRestriction.setRestrictFrame(true);
        rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
        rangeRestriction.setExtendMinX(2.0);
        rangeRestriction.setExtendMaxX(2.0);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMaxY(0.1);
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
        this.addSeriesLabelMarker();
        this.setData("org.eclipse.e4.ui.css.CssClassName", "MassSpectrumChart");
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("m/z");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(Messages.getString("INTENSITY"));
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(Messages.getString("RELATIVE_INTENSITY"), (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void addSeriesLabelMarker() {
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                BarSeriesIon barSeriesIon;
                List<BarSeriesIon> barSeriesIons = MassSpectrumChart.this.getBarSeriesIonList();
                Collections.sort(barSeriesIons, MassSpectrumChart.this.barSeriesIonComparator);
                int barSeriesSize = barSeriesIons.size();
                int limit = MassSpectrumChart.this.numberOfHighestIntensitiesToLabel;
                int i = 0;
                while (i < limit) {
                    if (i < barSeriesSize) {
                        barSeriesIon = barSeriesIons.get(i);
                        MassSpectrumChart.this.printLabel(barSeriesIon, e);
                    }
                    ++i;
                }
                limit = barSeriesIons.size() - MassSpectrumChart.this.numberOfHighestIntensitiesToLabel;
                limit = limit < 0 ? 0 : limit;
                i = barSeriesIons.size() - 1;
                while (i >= limit) {
                    barSeriesIon = barSeriesIons.get(i);
                    if (barSeriesIon.getIntensity() < 0.0) {
                        MassSpectrumChart.this.printLabel(barSeriesIon, e);
                    }
                    --i;
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
    }

    private void printLabel(BarSeriesIon barSeriesIon, PaintEvent e) {
        Point point = barSeriesIon.getPoint();
        String label = this.getLabel(barSeriesIon.getMz());
        boolean negative = barSeriesIon.getIntensity() < 0.0;
        Point labelSize = e.gc.textExtent(label);
        int x = (int)((double)point.x + 0.5 - (double)labelSize.x / 2.0);
        int y = point.y;
        if (!negative) {
            y = point.y - labelSize.y;
        }
        e.gc.drawText(label, x, y, true);
    }

    private String getLabel(double mz) {
        String label;
        switch (this.labelOption) {
            case NOMIMAL: {
                label = Integer.toString((int)mz);
                break;
            }
            case EXACT: {
                DecimalFormat decimalFormat = this.getDecimalFormatMZ();
                label = decimalFormat.format(mz);
                break;
            }
            case CUSTOM: {
                label = this.customLabels.get(mz);
                if (label != null) break;
                label = "";
                break;
            }
            default: {
                label = "";
            }
        }
        return label;
    }

    private List<BarSeriesIon> getBarSeriesIonList() {
        ISeries[] series;
        ArrayList<BarSeriesIon> barSeriesIons = new ArrayList<BarSeriesIon>();
        int widthPlotArea = this.getBaseChart().getPlotArea().getSize().x;
        ISeries[] iSeriesArray = series = this.getBaseChart().getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries barSeries = iSeriesArray[n2];
            if (barSeries != null) {
                double[] xSeries = barSeries.getXSeries();
                double[] ySeries = barSeries.getYSeries();
                int size = barSeries.getXSeries().length;
                int i = 0;
                while (i < size) {
                    Point point = barSeries.getPixelCoordinates(i);
                    if (point.x >= 0 && point.x <= widthPlotArea) {
                        barSeriesIons.add(new BarSeriesIon(xSeries[i], ySeries[i], point));
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return barSeriesIons;
    }

    private DecimalFormat getDecimalFormatMZ() {
        IAxisSettings axisSettings = this.getBaseChart().getXAxisSettings(0);
        if (axisSettings != null) {
            return axisSettings.getDecimalFormat();
        }
        return DEFAULT_DECIMAL_FORMAT;
    }

    public static enum LabelOption {
        NOMIMAL,
        EXACT,
        CUSTOM;

    }
}

