/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;

public class PerspectiveActivatedCondition
extends DefaultCondition {
    private final SWTWorkbenchBot bot;
    private final String perspectiveName;
    private final boolean negate;

    public PerspectiveActivatedCondition(SWTWorkbenchBot bot, String perspectiveName) {
        this(bot, perspectiveName, false);
    }

    public PerspectiveActivatedCondition(SWTWorkbenchBot bot, String perspectiveName, boolean negate) {
        this.bot = bot;
        this.perspectiveName = perspectiveName;
        this.negate = negate;
    }

    public boolean test() throws Exception {
        if (this.negate) {
            return !this.bot.activePerspective().getLabel().equals(this.perspectiveName);
        }
        return this.bot.activePerspective().getLabel().equals(this.perspectiveName);
    }

    public String getFailureMessage() {
        if (this.negate) {
            return "The perspective " + this.perspectiveName + " has not yet been deactivated";
        }
        return "The perspective " + this.perspectiveName + " has not yet been activated";
    }
}

