/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.tools.api.Messages;

public class HideDDiagramElementLabel
extends RecordingCommand {
    public static final String HIDE_LABEL = Messages.HideDDiagramElementLabel_hideLabel;
    public static final String HIDE_LABELS = Messages.HideDDiagramElementLabel_hideLabels;
    private final Set<?> objectsToHide;
    private final Map<EObject, List<Integer>> selectedLabelVisualIds;

    public HideDDiagramElementLabel(TransactionalEditingDomain domain, Set<?> elementsToHide) {
        super(domain);
        if (elementsToHide != null && elementsToHide.size() > 1) {
            this.setLabel(HIDE_LABELS);
        } else {
            this.setLabel(HIDE_LABEL);
        }
        this.objectsToHide = elementsToHide;
        this.selectedLabelVisualIds = Collections.EMPTY_MAP;
    }

    public HideDDiagramElementLabel(TransactionalEditingDomain domain, Set<?> elementsToHide, Map<EObject, List<Integer>> selectedLabelVisualIds) {
        super(domain);
        if (elementsToHide != null && elementsToHide.size() > 1) {
            this.setLabel(HIDE_LABELS);
        } else {
            this.setLabel(HIDE_LABEL);
        }
        this.objectsToHide = elementsToHide;
        this.selectedLabelVisualIds = selectedLabelVisualIds;
    }

    protected void setInvisible(DDiagramElement element) {
        DDiagramElementQuery diagramElementQuery = new DDiagramElementQuery(element);
        if (diagramElementQuery.canHideLabel()) {
            if (this.selectedLabelVisualIds.keySet().contains(element)) {
                HideFilterHelper.INSTANCE.hideLabel(element, this.selectedLabelVisualIds);
            } else if (!diagramElementQuery.isLabelHidden()) {
                HideFilterHelper.INSTANCE.hideLabel(element);
            }
        }
    }

    protected void doExecute() {
        for (Object obj : this.objectsToHide) {
            if (!(obj instanceof DDiagramElement)) continue;
            this.setInvisible((DDiagramElement)obj);
        }
    }
}

