/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.elk.core.debug.wizard.AlgorithmProjectCreationPage;
import org.eclipse.elk.core.debug.wizard.templates.LayoutProviderTemplate;
import org.eclipse.elk.core.debug.wizard.templates.MelkTemplate;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.templates.PluginReference;

public class AlgorithmPluginContentWizard
extends Wizard
implements IPluginContentWizard {
    private static final String[] PLUGIN_DEPENDENCIES = new String[]{"org.eclipse.elk.core", "org.eclipse.elk.graph", "org.eclipse.elk.alg.common", "com.google.guava"};
    private static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    private String id;
    private String plugInName;
    private String algorithmName;
    private AlgorithmProjectCreationPage page;

    public void init(IFieldData data) {
        this.id = data.getId();
        this.plugInName = data.getName();
    }

    public void addPages() {
        super.addPages();
        this.page = new AlgorithmProjectCreationPage(this.plugInName);
        this.addPage((IWizardPage)this.page);
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        return (IPluginReference[])Arrays.stream(PLUGIN_DEPENDENCIES).map(id -> new PluginReference(id)).toArray(IPluginReference[]::new);
    }

    public String[] getNewFiles() {
        return new String[0];
    }

    public boolean performFinish() {
        return this.page != null && this.page.getAlgorithmName().trim().length() > 0;
    }

    public boolean performFinish(IProject project, IPluginModelBase model, IProgressMonitor monitor) {
        this.algorithmName = this.page != null && !this.page.getAlgorithmName().trim().equals("") ? String.valueOf(this.page.getAlgorithmName().substring(0, 1).toUpperCase()) + this.page.getAlgorithmName().substring(1) : String.valueOf(this.plugInName.substring(0, 1).toUpperCase()) + this.plugInName.substring(1);
        String path = "src/";
        try {
            String[] stringArray = this.id.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                IFolder folder = project.getFolder(String.valueOf(path) + part);
                folder.create(false, false, monitor);
                path = String.valueOf(path) + part + "/";
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        this.createLayoutProvider(project, monitor);
        this.createMelkFile(project, monitor);
        this.createServiceFile(project, monitor);
        this.addXtextNature(project, monitor);
        return true;
    }

    private void createLayoutProvider(IProject project, IProgressMonitor monitor) {
        String fileContent = LayoutProviderTemplate.buildFileContent(this.id, this.algorithmName);
        String path = "/src/" + this.id.replace(".", "/") + "/" + this.algorithmName + "LayoutProvider.java";
        IFile layoutProvider = project.getFile(path);
        try {
            layoutProvider.create((InputStream)new ByteArrayInputStream(fileContent.getBytes()), false, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createMelkFile(IProject project, IProgressMonitor monitor) {
        String fileContent = MelkTemplate.buildFileContent(this.id, this.id, String.valueOf(this.algorithmName) + "LayoutProvider", this.id, this.algorithmName, this.algorithmName);
        IFile melk = project.getFile("/src/" + this.id.replace(".", "/") + "/" + this.plugInName + ".melk");
        try {
            melk.create((InputStream)new ByteArrayInputStream(fileContent.getBytes()), false, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createServiceFile(IProject project, IProgressMonitor monitor) {
        String fileContent = String.valueOf(this.id) + "." + this.algorithmName + "MetadataProvider";
        try {
            IFolder srcMetaInf = project.getFolder("/src/META-INF");
            srcMetaInf.create(true, true, monitor);
            IFolder srcMetaInfServices = project.getFolder("/src/META-INF/services");
            srcMetaInfServices.create(true, true, monitor);
            IFile serviceFile = project.getFile("/src/META-INF/services/org.eclipse.elk.core.data.ILayoutMetaDataProvider");
            serviceFile.create((InputStream)new ByteArrayInputStream(fileContent.getBytes()), false, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addXtextNature(IProject project, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = XTEXT_NATURE;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

