/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator.sorter;

import java.text.Collator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class RepresentationInSemanticSorter
extends ViewerSorter {
    public RepresentationInSemanticSorter() {
    }

    public RepresentationInSemanticSorter(Collator collator) {
        super(collator);
    }

    public int category(Object element) {
        int category = 3;
        if (element instanceof DRepresentationDescriptor) {
            category = 1;
        } else if (element instanceof EObject) {
            category = 2;
        }
        return category;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        if (e1 instanceof DRepresentationDescriptor && e2 instanceof DRepresentationDescriptor) {
            result = this.compareRepresentations(viewer, (DRepresentationDescriptor)e1, (DRepresentationDescriptor)e2);
        } else if (e1 instanceof DRepresentationDescriptor) {
            result = -1;
        } else if (e2 instanceof DRepresentationDescriptor) {
            result = 1;
        }
        return result;
    }

    private int compareRepresentations(Viewer viewer, DRepresentationDescriptor e1, DRepresentationDescriptor e2) {
        String defaultName = "";
        int result = Collator.getInstance().compare(e1 != null ? e1.getName() : defaultName, e2 != null ? e2.getName() : defaultName);
        if (e1 != null && e2 != null && e1.eClass() != null) {
            if (!e1.eClass().equals(e2.eClass())) {
                result = Collator.getInstance().compare(e1.eClass().getName(), e2.eClass().getName());
            } else {
                RepresentationDescription d1 = e1.getDescription();
                RepresentationDescription d2 = e2.getDescription();
                if (d1 != null && d2 != null && d1.eClass() != null && !d1.eClass().equals(d2.eClass())) {
                    result = Collator.getInstance().compare(d1.eClass().getName(), d2.eClass().getName());
                }
            }
        }
        return result;
    }
}

