/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.labelservice;

import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.internal.core.services.label.EMFFormsLabelProviderImpl;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.utils.VDomainModelReferenceExtensions;
import org.eclipse.set.utils.emfforms.Annotations;
import org.osgi.service.component.annotations.Component;

@Component
public class ToolboxLabelProvider
extends EMFFormsLabelProviderImpl {
    private static final String ALTERNATE_DISPLAY_NAME_SUPPLIER = "AlternateDisplayNameSupplier";
    private static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    private static final String KEY_DOCUMENTATION = "documentation";

    private static String getDescription(EStructuralFeature domainModelEFeature) {
        if (domainModelEFeature == null) {
            return null;
        }
        return Annotations.getValue((EStructuralFeature)domainModelEFeature, (String)GEN_MODEL_PACKAGE_NS_URI, (String)KEY_DOCUMENTATION);
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        if (domainModelReference instanceof VFeaturePathDomainModelReference) {
            VFeaturePathDomainModelReference featurePathDomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
            String documentation = ToolboxLabelProvider.getDescription(featurePathDomainModelReference.getDomainModelEFeature());
            if (documentation == null && VDomainModelReferenceExtensions.isValueField((VDomainModelReference)domainModelReference)) {
                EObject object = VDomainModelReferenceExtensions.resolve((VDomainModelReference)domainModelReference, (EObject)rootObject);
                documentation = ToolboxLabelProvider.getDescription(object.eContainingFeature());
            }
            return new WritableValue((Object)documentation, String.class);
        }
        return new WritableValue(null, String.class);
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        VElement vElement;
        String key;
        EObject container = domainModelReference.eContainer();
        if (container instanceof VElement && (key = Annotations.getViewModelValue((VElement)(vElement = (VElement)container), (String)ALTERNATE_DISPLAY_NAME_SUPPLIER)) != null) {
            ToolboxViewModelService viewModelService = Services.getToolboxViewModelService();
            Supplier displayNameSupplier = (Supplier)viewModelService.get(key);
            if (displayNameSupplier == null) {
                throw new IllegalArgumentException("No supplier for key=\"" + key + "\"");
            }
            return new WritableValue((Object)((String)displayNameSupplier.get()), String.class);
        }
        return super.getDisplayName(domainModelReference, rootObject);
    }
}

