/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.ssli;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Lageplan_Kurz_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Fahrstrasse.ENUMRangierGegenfahrtausschluss;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Rangier_Gegenfahrtausschluss_TypeClass;
import org.eclipse.set.model.planpro.Gleis.Bez_Gleis_Bezeichnung_TypeClass;
import org.eclipse.set.model.planpro.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.model.planpro.Gleis.Gleis_Bezeichnung_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.ENUMSignalArt;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Art_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Fahrweg_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_Gleisbezechnung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Ziel_TypeClass;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.event.EventAdmin;

public class SsliTransformator
extends AbstractPlanPro2TableModelTransformator {
    private TMFactory factory = null;
    private MultiContainer_AttributeGroup container = null;
    private final TopologicalGraphService topGraphService;
    private final HashMap<ArrayList<?>, Table> _createCache_transform = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, TableRow> _createCache_transform_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, String> _createCache_transformToBezeichnung = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Set<ENUMRangierGegenfahrtausschluss>> _createCache_transformToGegenfahrtausschluesse = CollectionLiterals.newHashMap();

    public SsliTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService, TopologicalGraphService topGraphService, EventAdmin eventAdmin) {
        super(cols, enumTranslationService, eventAdmin);
        this.topGraphService = topGraphService;
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory, Stell_Bereich controlArea) {
        this.factory = factory;
        this.container = container;
        return this.transform(container, controlArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table transform(MultiContainer_AttributeGroup container, Stell_Bereich controlArea) {
        Table _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{container, controlArea});
        HashMap<ArrayList<?>, Table> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Table _table;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _table = this.factory.getTable();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, container, controlArea);
        return _result;
    }

    private void _init_transform(Table it, MultiContainer_AttributeGroup container, Stell_Bereich controlArea) {
        Functions.Function1 _function = it_1 -> UrObjectExtensions.isPlanningObject((Ur_Objekt)it_1);
        Iterable gleisBezeichnung = UrObjectExtensions.filterObjectsInControlArea((Iterable)IterableExtensions.filter((Iterable)container.getGleisBezeichnung(), (Functions.Function1)_function), (Stell_Bereich)controlArea);
        Functions.Function1 _function_1 = it_1 -> UrObjectExtensions.isPlanningObject((Ur_Objekt)it_1);
        Functions.Function1 _function_2 = it_1 -> this.getGeneralbedingung((Gleis_BezeichnungBegrenzung)it_1);
        Consumer<Gleis_BezeichnungBegrenzung> _function_3 = it_1 -> {
            boolean _isInterrupted = Thread.currentThread().isInterrupted();
            if (_isInterrupted) {
                return;
            }
            this.transform((Gleis_BezeichnungBegrenzung)it_1);
        };
        IterableExtensions.filter(this.transformToBegrenzungen(gleisBezeichnung, IterableExtensions.filter((Iterable)container.getSignal(), (Functions.Function1)_function_1)), (Functions.Function1)_function_2).forEach(_function_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRow transform(Gleis_BezeichnungBegrenzung gleisBezeichnungBegrenzung) {
        TableRow _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Gleis_BezeichnungBegrenzung[]{gleisBezeichnungBegrenzung});
        HashMap<ArrayList<?>, TableRow> hashMap = this._createCache_transform_1;
        synchronized (hashMap) {
            TableRow _newTableRow;
            if (this._createCache_transform_1.containsKey(_cacheKey)) {
                return this._createCache_transform_1.get(_cacheKey);
            }
            _result = _newTableRow = this.factory.newTableRow((Ur_Objekt)gleisBezeichnungBegrenzung.gleisBezeichnung);
            this._createCache_transform_1.put(_cacheKey, _result);
        }
        this._init_transform(_result, gleisBezeichnungBegrenzung);
        return _result;
    }

    private void _init_transform(TableRow it, Gleis_BezeichnungBegrenzung gleisBezeichnungBegrenzung) {
        Gleis_Bezeichnung gleisBezeichnung = gleisBezeichnungBegrenzung.gleisBezeichnung;
        Iterable _plus = Iterables.concat(gleisBezeichnungBegrenzung.zgFahrtVerbot, gleisBezeichnungBegrenzung.raFahrtVerbot);
        Iterable begrenzungen = Iterables.concat((Iterable)_plus, gleisBezeichnungBegrenzung.raGegenfahrtausschluss);
        Functions.Function1 _function = it_1 -> this.transformToBezeichnung((Gleis_Bezeichnung)it_1);
        this.fill(it, this.getColumn(this.cols, "A"), gleisBezeichnung, _function);
        List<Double> laengenBegrenzung = this.getLaengenBegrenzung(gleisBezeichnungBegrenzung);
        Functions.Function1 _function_1 = it_1 -> {
            Functions.Function1 _function_2 = it_2 -> String.format("%.0f", Math.floor(it_2));
            return ListExtensions.map((List)laengenBegrenzung, (Functions.Function1)_function_2);
        };
        Functions.Function1 _function_2 = it_1 -> it_1;
        this.fillIterable(it, this.getColumn(this.cols, "B"), gleisBezeichnung, _function_1, null, _function_2);
        Functions.Function1 _function_3 = it_1 -> {
            Functions.Function1 _function_4 = it_2 -> SsliTransformator.lageplanKurzContains(it_2, "POUVWY", true);
            Functions.Function1 _function_5 = it_2 -> {
                Bezeichnung_Element_AttributeGroup _bezeichnung = it_2.getBezeichnung();
                Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                if (_bezeichnung != null) {
                    _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                }
                String _wert = null;
                if (_bezeichnungTabelle != null) {
                    _wert = _bezeichnungTabelle.getWert();
                }
                return _wert;
            };
            return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)_function_4), (Functions.Function1)_function_5);
        };
        Functions.Function1 _function_4 = it_1 -> it_1;
        this.fillIterable(it, this.getColumn(this.cols, "C"), gleisBezeichnung, _function_3, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, _function_4);
        Functions.Function1 _function_5 = it_1 -> {
            Functions.Function1 _function_6 = it_2 -> SsliTransformator.lageplanKurzContains(it_2, "NQRSTX", false);
            Functions.Function1 _function_7 = it_2 -> {
                Bezeichnung_Element_AttributeGroup _bezeichnung = it_2.getBezeichnung();
                Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                if (_bezeichnung != null) {
                    _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                }
                String _wert = null;
                if (_bezeichnungTabelle != null) {
                    _wert = _bezeichnungTabelle.getWert();
                }
                return _wert;
            };
            return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)_function_6), (Functions.Function1)_function_7);
        };
        Functions.Function1 _function_6 = it_1 -> it_1;
        this.fillIterable(it, this.getColumn(this.cols, "D"), gleisBezeichnung, _function_5, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, _function_6);
        ColumnDescriptor _column = this.getColumn(this.cols, "E");
        Functions.Function1 _function_7 = it_1 -> {
            Functions.Function1 _function_8 = it_2 -> {
                boolean _isEmpty;
                boolean _not;
                boolean _tripleNotEquals;
                boolean _and = false;
                Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = it_2.getSignalFstrAusInselgleis();
                EList _iDZgFahrtGleichzeitigVerbot = null;
                if (_signalFstrAusInselgleis != null) {
                    _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDZgFahrtGleichzeitigVerbot();
                }
                boolean bl = _tripleNotEquals = _iDZgFahrtGleichzeitigVerbot != null;
                _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = it_2.getSignalFstrAusInselgleis().getIDZgFahrtGleichzeitigVerbot().isEmpty()));
                return _and;
            };
            return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function_8);
        };
        Functions.Function1 _function_8 = it_1 -> this.translate(true);
        Case _case = new Case(_function_7, _function_8);
        Functions.Function1 _function_9 = it_1 -> {
            Functions.Function1 _function_10 = it_2 -> SignalExtensions.isStartOfAnyTrainRoute((Signal)it_2);
            return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function_10);
        };
        Functions.Function1 _function_10 = it_1 -> this.translate(false);
        Case _case_1 = new Case(_function_9, _function_10);
        this.fillSwitch(it, _column, gleisBezeichnung, new Case[]{_case, _case_1});
        ColumnDescriptor _column_1 = this.getColumn(this.cols, "F");
        Functions.Function1 _function_11 = it_1 -> {
            Functions.Function1 _function_12 = it_2 -> this.transformToGegenfahrtausschluesse((Signal)it_2).contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_JA) || this.transformToGegenfahrtausschluesse((Signal)it_2).contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_INSELGLEIS_FREI);
            return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function_12);
        };
        Functions.Function1 _function_12 = it_1 -> this.translate(true);
        Case _case_2 = new Case(_function_11, _function_12);
        Functions.Function1 _function_13 = it_1 -> {
            Functions.Function1 _function_14 = it_2 -> SignalExtensions.isStartOrDestinationOfAnyShuntingRoute((Signal)it_2, (boolean)false);
            return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function_14);
        };
        Functions.Function1 _function_14 = it_1 -> this.translate(false);
        Case _case_3 = new Case(_function_13, _function_14);
        this.fillSwitch(it, _column_1, gleisBezeichnung, new Case[]{_case_2, _case_3});
        ColumnDescriptor _column_2 = this.getColumn(this.cols, "G");
        Functions.Function1 _function_15 = it_1 -> {
            Functions.Function1 _function_16 = it_2 -> {
                boolean _isEmpty;
                boolean _not;
                boolean _tripleNotEquals;
                boolean _and = false;
                Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = it_2.getSignalFstrAusInselgleis();
                EList _iDRaFahrtGleichzeitigVerbot = null;
                if (_signalFstrAusInselgleis != null) {
                    _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
                }
                boolean bl = _tripleNotEquals = _iDRaFahrtGleichzeitigVerbot != null;
                _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = it_2.getSignalFstrAusInselgleis().getIDRaFahrtGleichzeitigVerbot().isEmpty()));
                return _and;
            };
            return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function_16);
        };
        Functions.Function1 _function_16 = it_1 -> this.translate(true);
        Case _case_4 = new Case(_function_15, _function_16);
        Functions.Function1 _function_17 = it_1 -> {
            Functions.Function1 _function_18 = it_2 -> SignalExtensions.isStartOrDestinationOfAnyShuntingRoute((Signal)it_2, (boolean)true);
            return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function_18);
        };
        Functions.Function1 _function_18 = it_1 -> this.translate(false);
        Case _case_5 = new Case(_function_17, _function_18);
        this.fillSwitch(it, _column_2, gleisBezeichnung, new Case[]{_case_4, _case_5});
        this.fillFootnotes(it, (Basis_Objekt)gleisBezeichnung);
    }

    private List<Double> getLaengenBegrenzung(Gleis_BezeichnungBegrenzung gleis) {
        Functions.Function1 _function;
        Iterable _plus = Iterables.concat(gleis.zgFahrtVerbot, gleis.raFahrtVerbot);
        Iterable begrenzungen = Iterables.concat((Iterable)_plus, gleis.raGegenfahrtausschluss);
        List<Double> shortest = this.getShortestSignalDistance(IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)(_function = it -> {
            Signal_Real_AttributeGroup _signalReal = it.getSignalReal();
            Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
            if (_signalReal != null) {
                _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
            }
            Signal_Art_TypeClass _signalArt = null;
            if (_signalRealAktivSchirm != null) {
                _signalArt = _signalRealAktivSchirm.getSignalArt();
            }
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMSignalArt[]{ENUMSignalArt.ENUM_SIGNAL_ART_HAUPTSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_HAUPTSPERRSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_MEHRABSCHNITTSSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_MEHRABSCHNITTSSPERRSIGNAL})).contains(_signalArt);
        })));
        if (shortest != null) {
            return shortest;
        }
        return this.getShortestSignalDistance(begrenzungen);
    }

    private List<Double> getShortestSignalDistance(Iterable<Signal> begrenzungen) {
        Functions.Function1 _function = signalA -> {
            Functions.Function1 _function_1 = signalB -> {
                List _xblockexpression = null;
                if (signalA == signalB) {
                    return null;
                }
                _xblockexpression = IterableExtensions.toList(this.createDistances((Punkt_Objekt)signalA, (Punkt_Objekt)signalB));
                return _xblockexpression;
            };
            Functions.Function1 _function_2 = it -> {
                ToDoubleFunction<Double> _function_3 = d -> d;
                return it.stream().mapToDouble(_function_3).sum();
            };
            List minLenFromA = IterableExtensions.sortBy((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)begrenzungen, (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
            boolean _isEmpty = minLenFromA.isEmpty();
            if (_isEmpty) {
                return null;
            }
            return (List)minLenFromA.get(0);
        };
        Iterable minLens = IterableExtensions.filterNull((Iterable)IterableExtensions.map(begrenzungen, (Functions.Function1)_function));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)minLens);
        if (_isEmpty) {
            return null;
        }
        Functions.Function1 _function_1 = it -> {
            ToDoubleFunction<Double> _function_2 = d -> d;
            return it.stream().mapToDouble(_function_2).sum();
        };
        return (List)IterableExtensions.sortBy((Iterable)minLens, (Functions.Function1)_function_1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transformToBezeichnung(Gleis_Bezeichnung gleisBezeichnung) {
        String _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Gleis_Bezeichnung[]{gleisBezeichnung});
        HashMap<ArrayList<?>, String> hashMap = this._createCache_transformToBezeichnung;
        synchronized (hashMap) {
            String _createBezeichnung;
            if (this._createCache_transformToBezeichnung.containsKey(_cacheKey)) {
                return this._createCache_transformToBezeichnung.get(_cacheKey);
            }
            _result = _createBezeichnung = this.createBezeichnung(gleisBezeichnung);
            this._createCache_transformToBezeichnung.put(_cacheKey, _result);
        }
        this._init_transformToBezeichnung(_result, gleisBezeichnung);
        return _result;
    }

    private void _init_transformToBezeichnung(String it, Gleis_Bezeichnung gleisBezeichnung) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ENUMRangierGegenfahrtausschluss> transformToGegenfahrtausschluesse(Signal signal) {
        HashSet<ENUMRangierGegenfahrtausschluss> _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Signal[]{signal});
        HashMap<ArrayList<?>, Set<ENUMRangierGegenfahrtausschluss>> hashMap = this._createCache_transformToGegenfahrtausschluesse;
        synchronized (hashMap) {
            HashSet<ENUMRangierGegenfahrtausschluss> _hashSet;
            if (this._createCache_transformToGegenfahrtausschluesse.containsKey(_cacheKey)) {
                return this._createCache_transformToGegenfahrtausschluesse.get(_cacheKey);
            }
            _result = _hashSet = new HashSet<ENUMRangierGegenfahrtausschluss>();
            this._createCache_transformToGegenfahrtausschluesse.put(_cacheKey, _result);
        }
        this._init_transformToGegenfahrtausschluesse(_result, signal);
        return _result;
    }

    private void _init_transformToGegenfahrtausschluesse(HashSet<ENUMRangierGegenfahrtausschluss> it, Signal signal) {
        Functions.Function1 _function = it_1 -> {
            ID_Ziel_TypeClass _iDZiel = it_1.getIDZiel();
            Basis_Objekt _value = null;
            if (_iDZiel != null) {
                _value = _iDZiel.getValue();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_value != null) {
                _identitaet = _value.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            Identitaet_TypeClass _identitaet_1 = null;
            if (signal != null) {
                _identitaet_1 = signal.getIdentitaet();
            }
            String _wert_1 = null;
            if (_identitaet_1 != null) {
                _wert_1 = _identitaet_1.getWert();
            }
            return Objects.equals(_wert, _wert_1);
        };
        Functions.Function1 _function_1 = fw -> {
            Functions.Function1 _function_2 = it_1 -> {
                ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = it_1.getIDFstrFahrweg();
                Fstr_Fahrweg _value = null;
                if (_iDFstrFahrweg != null) {
                    _value = _iDFstrFahrweg.getValue();
                }
                Identitaet_TypeClass _identitaet = null;
                if (_value != null) {
                    _identitaet = _value.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (fw != null) {
                    _identitaet_1 = fw.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                return Objects.equals(_wert, _wert_1);
            };
            return IterableExtensions.filter((Iterable)this.container.getFstrZugRangier(), (Functions.Function1)_function_2);
        };
        Functions.Function1 _function_2 = it_1 -> {
            Fstr_Rangier_AttributeGroup _fstrRangier = it_1.getFstrRangier();
            Rangier_Gegenfahrtausschluss_TypeClass _rangierGegenfahrtausschluss = null;
            if (_fstrRangier != null) {
                _rangierGegenfahrtausschluss = _fstrRangier.getRangierGegenfahrtausschluss();
            }
            ENUMRangierGegenfahrtausschluss _wert = null;
            if (_rangierGegenfahrtausschluss != null) {
                _wert = _rangierGegenfahrtausschluss.getWert();
            }
            return _wert;
        };
        Iterables.addAll(it, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)this.container.getFstrFahrweg(), (Functions.Function1)_function), (Functions.Function1)_function_1))), (Functions.Function1)_function_2));
    }

    private Iterable<Gleis_BezeichnungBegrenzung> transformToBegrenzungen(Iterable<Gleis_Bezeichnung> gleis, Iterable<Signal> signals) {
        HashMap result = new HashMap();
        Consumer<Gleis_Bezeichnung> _function = g -> {
            Gleis_BezeichnungBegrenzung gleisBegrenzung = new Gleis_BezeichnungBegrenzung((Gleis_Bezeichnung)g);
            result.put(g.getBezeichnung().getBezGleisBezeichnung().getWert(), gleisBegrenzung);
            List signaleAufGleis = BereichObjektExtensions.filterContained((Bereich_Objekt)g, (Iterable)this.container.getSignal());
            Functions.Function1 _function_1 = it -> {
                boolean _xblockexpression = false;
                Set<ENUMRangierGegenfahrtausschluss> ausschluesse = this.transformToGegenfahrtausschluesse((Signal)it);
                _xblockexpression = ausschluesse.contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_JA) || ausschluesse.contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_INSELGLEIS_FREI);
                return _xblockexpression;
            };
            gleisBegrenzung.raGegenfahrtausschluss = IterableExtensions.filter((Iterable)signaleAufGleis, (Functions.Function1)_function_1);
        };
        gleis.forEach(_function);
        Consumer<Signal> _function_1 = signal -> {
            Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
            if (signal != null) {
                _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
            }
            EList _iDRaFahrtGleichzeitigVerbot = null;
            if (_signalFstrAusInselgleis != null) {
                _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
            }
            EList rafahrt = _iDRaFahrtGleichzeitigVerbot;
            Iterable _filter = null;
            if (rafahrt != null) {
                Functions.Function1 _function_2 = gl -> {
                    String _wert = null;
                    if (gl != null) {
                        _wert = gl.getWert();
                    }
                    return result.containsKey(_wert);
                };
                _filter = IterableExtensions.filter((Iterable)rafahrt, (Functions.Function1)_function_2);
            }
            if (_filter != null) {
                Consumer<ID_Signal_Gleisbezechnung_TypeClass> _function_3 = gl -> {
                    String _wert = null;
                    if (gl != null) {
                        _wert = gl.getWert();
                    }
                    ((Gleis_BezeichnungBegrenzung)map.get((Object)_wert)).raFahrtVerbot.add((Signal)signal);
                };
                _filter.forEach(_function_3);
            }
            Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis_1 = null;
            if (signal != null) {
                _signalFstrAusInselgleis_1 = signal.getSignalFstrAusInselgleis();
            }
            EList _iDZgFahrtGleichzeitigVerbot = null;
            if (_signalFstrAusInselgleis_1 != null) {
                _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis_1.getIDZgFahrtGleichzeitigVerbot();
            }
            EList zgfahrt = _iDZgFahrtGleichzeitigVerbot;
            Iterable _filter_1 = null;
            if (zgfahrt != null) {
                Functions.Function1 _function_4 = gl -> {
                    String _wert = null;
                    if (gl != null) {
                        _wert = gl.getWert();
                    }
                    return result.containsKey(_wert);
                };
                _filter_1 = IterableExtensions.filter((Iterable)zgfahrt, (Functions.Function1)_function_4);
            }
            if (_filter_1 != null) {
                Consumer<ID_Signal_Gleisbezechnung_TypeClass> _function_5 = gl -> {
                    String _wert = null;
                    if (gl != null) {
                        _wert = gl.getWert();
                    }
                    ((Gleis_BezeichnungBegrenzung)map.get((Object)_wert)).zgFahrtVerbot.add((Signal)signal);
                };
                _filter_1.forEach(_function_5);
            }
        };
        signals.forEach(_function_1);
        return result.values();
    }

    private String createBezeichnung(Gleis_Bezeichnung gleisBezeichnung) {
        Gleis_Bezeichnung_Bezeichnung_AttributeGroup _bezeichnung = null;
        if (gleisBezeichnung != null) {
            _bezeichnung = gleisBezeichnung.getBezeichnung();
        }
        Bez_Gleis_Bezeichnung_TypeClass _bezGleisBezeichnung = null;
        if (_bezeichnung != null) {
            _bezGleisBezeichnung = _bezeichnung.getBezGleisBezeichnung();
        }
        String _wert = null;
        if (_bezGleisBezeichnung != null) {
            _wert = _bezGleisBezeichnung.getWert();
        }
        return _wert;
    }

    private Iterable<Double> createDistances(Punkt_Objekt p1, Punkt_Objekt p2) {
        Functions.Function1 _function = it -> new TopPoint(it);
        List points1 = ListExtensions.map((List)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p1), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> new TopPoint(it);
        List points2 = ListExtensions.map((List)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p2), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = pa -> {
            Functions.Function1 _function_3 = pb -> this.topGraphService.findShortestDistance(pa, pb);
            return ListExtensions.map((List)points2, (Functions.Function1)_function_3);
        };
        Functions.Function1 _function_3 = it -> it.isPresent();
        Functions.Function1 _function_4 = it -> ((BigDecimal)it.get()).doubleValue();
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)points1, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
    }

    private boolean getGeneralbedingung(Gleis_BezeichnungBegrenzung gleisBezeichnung) {
        return gleisBezeichnung.zgFahrtVerbot.size() >= 2 || gleisBezeichnung.raFahrtVerbot.size() >= 2 || IterableExtensions.size(gleisBezeichnung.raGegenfahrtausschluss) == 2;
    }

    private static boolean lageplanKurzContains(Signal signal, String letters, boolean isEven) {
        String bezeichnung;
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (signal != null) {
            _bezeichnung = signal.getBezeichnung();
        }
        Bezeichnung_Lageplan_Kurz_TypeClass _bezeichnungLageplanKurz = null;
        if (_bezeichnung != null) {
            _bezeichnungLageplanKurz = _bezeichnung.getBezeichnungLageplanKurz();
        }
        String _wert = null;
        if (_bezeichnungLageplanKurz != null) {
            _wert = _bezeichnungLageplanKurz.getWert();
        }
        if ((bezeichnung = _wert) == null) {
            return false;
        }
        Functions.Function1 _function = it -> bezeichnung.contains(it.toString());
        boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)letters.toCharArray())), (Functions.Function1)_function);
        if (_exists) {
            return true;
        }
        try {
            int bezeichnungsNummer = Integer.parseInt(bezeichnung);
            if (isEven) {
                return bezeichnungsNummer % 2 == 0;
            }
            return bezeichnungsNummer % 2 != 0;
        }
        catch (Throwable _t) {
            if (!(_t instanceof NumberFormatException)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return false;
        }
    }

    private static class Gleis_BezeichnungBegrenzung {
        private Gleis_Bezeichnung gleisBezeichnung;
        private List<Signal> zgFahrtVerbot = new ArrayList<Signal>();
        private List<Signal> raFahrtVerbot = new ArrayList<Signal>();
        private Iterable<Signal> raGegenfahrtausschluss = new ArrayList<Signal>();

        public Gleis_BezeichnungBegrenzung(Gleis_Bezeichnung bezeichnung) {
            this.gleisBezeichnung = bezeichnung;
        }
    }
}

