/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class InternalImage
implements SerializableCompatibility {
    private final String resourceName;
    private final int width;
    private final int height;
    private final boolean external;

    InternalImage(String resourceName, int width, int height, boolean external) {
        ParamCheck.notNull(resourceName, "resourceName");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Illegal size");
        }
        this.resourceName = resourceName;
        this.width = width;
        this.height = height;
        this.external = external;
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        return ContextProvider.getApplicationContext().getImageDataFactory().findImageData(this);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isExternal() {
        return this.external;
    }
}

