/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssFont;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public abstract class Device
implements Drawable,
SerializableCompatibility {
    protected final SerializableLock deviceLock = new SerializableLock();
    private boolean disposed;

    public Color getSystemColor(int id) {
        this.checkDevice();
        ResourceFactory resourceFactory = ContextProvider.getApplicationContext().getResourceFactory();
        return switch (id) {
            case 37 -> resourceFactory.getColor(0, 0, 0, 0);
            case 1 -> resourceFactory.getColor(255, 255, 255);
            case 2 -> resourceFactory.getColor(0, 0, 0);
            case 3 -> resourceFactory.getColor(255, 0, 0);
            case 4 -> resourceFactory.getColor(128, 0, 0);
            case 5 -> resourceFactory.getColor(0, 255, 0);
            case 6 -> resourceFactory.getColor(0, 128, 0);
            case 7 -> resourceFactory.getColor(255, 255, 0);
            case 8 -> resourceFactory.getColor(128, 128, 0);
            case 9 -> resourceFactory.getColor(0, 0, 255);
            case 10 -> resourceFactory.getColor(0, 0, 128);
            case 11 -> resourceFactory.getColor(255, 0, 255);
            case 12 -> resourceFactory.getColor(128, 0, 128);
            case 13 -> resourceFactory.getColor(0, 255, 255);
            case 14 -> resourceFactory.getColor(0, 128, 128);
            case 15 -> resourceFactory.getColor(192, 192, 192);
            case 16 -> resourceFactory.getColor(128, 128, 128);
            default -> resourceFactory.getColor(0, 0, 0);
        };
    }

    public Font getSystemFont() {
        this.checkDevice();
        CssValue font = ThemeUtil.getCssValue("Display", "font", SimpleSelector.DEFAULT);
        return CssFont.createFont((CssFont)font);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        FontData[] result;
        block7: {
            this.checkDevice();
            result = new FontData[]{};
            if (!scalable) break block7;
            CssFont fontList = (CssFont)ThemeUtil.getCssValue("Display", "rwt-fontlist", SimpleSelector.DEFAULT);
            if (faceName == null) {
                result = new FontData[fontList.family.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = new FontData(fontList.family[i], 0, 0);
                    ++i;
                }
            } else {
                int counter = 0;
                int i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        ++counter;
                    }
                    ++i;
                }
                result = new FontData[counter];
                counter = 0;
                i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        result[counter++] = new FontData(fontList.family[i], 0, 0);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 16;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(0, 0);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (!this.isDisposed()) {
                this.checkDevice();
                this.release();
                this.destroy();
                this.disposed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            return this.disposed;
        }
    }

    protected void release() {
    }

    protected void destroy() {
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }
}

