/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.relationships;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.Order;

@Entity(name="XMLMergeCustomer")
@Table(name="CMP3_XML_MERGE_CUSTOMER")
@Access(value=AccessType.PROPERTY)
public class Customer
implements Serializable {
    private Integer customerId;
    @Access(value=AccessType.FIELD)
    @Version
    @Column(name="CUST_VERSION")
    private int version;
    private String city;
    private String name;
    private Collection<Order> orders;

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="XML_MERGE_CUSTOMER_TABLE_GENERATOR")
    @TableGenerator(name="XML_MERGE_CUSTOMER_TABLE_GENERATOR", table="CMP3_XML_MERGE_CUSTOMER_SEQ_INCORRECT_LONG_NAME_WILL_CAUSE_ERROR", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="CUST_SEQ")
    @Column(name="CUST_ID")
    public Integer getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Integer id) {
        this.customerId = id;
    }

    @Lob
    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    @Enumerated
    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    @PrivateOwned
    @OrderBy(value="valueThatShouldCauseAnException")
    public Collection<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> newValue) {
        this.orders = newValue;
    }

    public void addOrder(Order anOrder) {
        this.getOrders().add(anOrder);
        anOrder.setCustomer(this);
    }

    public void removeOrder(Order anOrder) {
        this.getOrders().remove(anOrder);
    }
}

