/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ChainedExceptionTestCase
extends AutoVerifyTestCase {
    private Exception internalException = null;
    private IllegalAccessException internalIllegalAccessException = null;
    private DatabaseException databaseException = null;
    private DescriptorException descriptorException = null;
    private QueryException queryException = null;
    private ValidationException validationException = null;

    public ChainedExceptionTestCase() {
        this.setDescription("This test ensures toplink uses the correct API for JDK 1.4 chained exceptions.");
    }

    public void setup() {
        this.internalException = new Exception("Test Exception");
        this.internalIllegalAccessException = new IllegalAccessException("Test Exception");
    }

    public void test() {
        this.databaseException = DatabaseException.configurationErrorNewInstanceIllegalAccessException((IllegalAccessException)this.internalIllegalAccessException, Object.class);
        this.descriptorException = DescriptorException.couldNotInstantiateIndirectContainerClass(Object.class, (Exception)this.internalException);
        this.queryException = QueryException.cannotAddElement((Object)new Object(), (Object)new Object(), (Exception)this.internalException);
        this.validationException = ValidationException.ejbInvalidProjectClass((String)"projectClassName", (String)"projectName", (Throwable)this.internalException);
    }

    public void verify() {
        if (this.databaseException.getInternalException() != this.databaseException.getCause() || this.databaseException.getCause() != this.internalIllegalAccessException) {
            throw new TestErrorException("JDK 1.4 Exception Chaining does not work correctly for DatabaseException.");
        }
        if (this.descriptorException.getInternalException() != this.descriptorException.getCause() || this.descriptorException.getCause() != this.internalException) {
            throw new TestErrorException("JDK 1.4 Exception Chaining does not work correctly for DescriptorException.");
        }
        if (this.queryException.getInternalException() != this.queryException.getCause() || this.queryException.getCause() != this.internalException) {
            throw new TestErrorException("JDK 1.4 Exception Chaining does not work correctly for QueryException.");
        }
        if (this.validationException.getInternalException() != this.validationException.getCause() || this.validationException.getCause() != this.internalException) {
            throw new TestErrorException("JDK 1.4 Exception Chaining does not work correctly for ValidationException.");
        }
    }
}

