/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.sql.SQLException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class BatchCommitTransactionExceptionTest
extends ExceptionTest {
    @Override
    public void reset() {
        super.reset();
        this.getSession().getLogin().dontUseBatchWriting();
    }

    public void setup() {
        this.expectedException = DatabaseException.sqlException((SQLException)new SQLException("", "", 102));
    }

    public void test() {
        Session session = this.getSession();
        DatabasePlatform plat = session.getPlatform();
        if (plat.isOracle() || plat.isSQLServer() || plat.isSybase() || plat.isSQLAnywhere() || plat.isMySQL() || plat.isSymfoware()) {
            DatabaseLogin login = session.getLogin();
            login.useBatchWriting();
            try {
                ((DatabaseSession)session).beginTransaction();
                session.executeNonSelectingCall((Call)new SQLCall("Insert into BOB Value"));
                ((DatabaseSession)session).commitTransaction();
            }
            catch (EclipseLinkException e) {
                this.caughtException = e;
                ((DatabaseSession)session).rollbackTransaction();
            }
        } else {
            throw new TestWarningException("Test not run on this database platform");
        }
    }
}

