/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_RegisterExisting_TestCase
extends AutoVerifyTestCase {
    protected Exception exception;

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            Employee employee = (Employee)this.getSession().readObject(Employee.class);
            uow.writeChanges();
            uow.registerExistingObject((Object)new Employee());
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.exception == null) {
            throw new TestErrorException("Exception not thrown attempting to registerExistingObject after writeChanges.");
        }
        if (!(this.exception instanceof ValidationException)) {
            throw new TestErrorException("Wrong exception type thrown.", (Throwable)this.exception);
        }
        ValidationException ve = (ValidationException)((Object)this.exception);
        if (ve.getErrorCode() != 7123) {
            throw new TestErrorException("Wrong exception thrown.", (Throwable)ve);
        }
    }

    public void reset() {
        this.exception = null;
    }
}

