/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote.rmi.IIOP;

import java.lang.reflect.Constructor;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.rmi.iiop.RMIRemoteSessionController;
import org.eclipse.persistence.sessions.remote.rmi.iiop.RMIRemoteSessionControllerDispatcher;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.remote.rmi.IIOP.RMIServerManager;

public class RMIServerManagerController
extends PortableRemoteObject
implements RMIServerManager {
    protected Session session;
    protected String controllerClassName;

    public RMIServerManagerController(Session session) throws RemoteException {
        this.session = session;
    }

    public RMIServerManagerController(Session session, String controllerClassName) throws RemoteException {
        this(session);
        this.controllerClassName = controllerClassName;
    }

    @Override
    public RMIRemoteSessionController createRemoteSessionController() {
        RMIRemoteSessionControllerDispatcher controller = null;
        if (this.controllerClassName == null) {
            try {
                controller = new RMIRemoteSessionControllerDispatcher(this.getSession());
            }
            catch (RemoteException exception) {
                System.out.println("Error in invocation " + exception.toString());
            }
        } else {
            try {
                Class<?> cls = Class.forName(this.controllerClassName);
                Class[] parameterTypes = new Class[]{Session.class};
                Constructor<?> constructor = cls.getConstructor(parameterTypes);
                Object[] params = new Object[]{this.getSession()};
                controller = (RMIRemoteSessionController)constructor.newInstance(params);
            }
            catch (Exception exception) {
                System.out.println("Error instantiating  " + this.controllerClassName + " " + exception.toString());
            }
        }
        return controller;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public static void start(Session session) {
        RMIServerManagerController.start(session, "SERVER-MANAGER");
    }

    public static void start(Session session, String nameToBind) {
        RMIServerManagerController.start(session, nameToBind, null);
    }

    public static void start(Session session, String nameToBind, String controllerClassName) {
        System.out.println("The following environment properties must be set to run this test.");
        System.out.println("-Djava.naming.factory.initial=com.sun.jndi.cosnaming.CNCtxFactory -Djava.naming.provider.url=iiop://localhost:900");
        System.out.println("The follwing corba naming server must also be started on the computer.");
        System.out.println("<java_home>/bin/tnameserv.exe");
        RMIServerManagerController manager = null;
        InitialContext initialNamingContext = null;
        try {
            initialNamingContext = new InitialContext();
        }
        catch (NamingException exception) {
            System.out.println("Naming Exception " + exception.toString());
        }
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            System.out.println("Security violation 1" + exception.toString());
        }
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (Exception exception) {
            System.out.println("Security violation 2" + exception.toString());
        }
        try {
            manager = new RMIServerManagerController(session, controllerClassName);
        }
        catch (RemoteException exception) {
            throw new TestProblemException("Corba not configured correctly, see system.out", (Throwable)exception);
        }
        try {
            initialNamingContext.unbind(nameToBind);
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            initialNamingContext.rebind(nameToBind, (Object)manager);
        }
        catch (Exception exception) {
            throw new TestProblemException("Corba not configured correctly, see system.out", (Throwable)exception);
        }
    }
}

