/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkConformReadObjectWithCriteriaTest
extends TestCase {
    protected UnitOfWork uow;
    protected ObjectLevelReadQuery queryToExecute;
    protected List<Employee> employees;

    public UnitOfWorkConformReadObjectWithCriteriaTest() {
        this.setDescription("UnitOfWorkConformReadObjectWithCriteriaTest");
    }

    public void setup() {
        this.employees = this.getSession().readAllObjects(Employee.class, new ExpressionBuilder().get("manager").notNull());
        for (Employee employee : this.employees) {
            UnitOfWorkConformReadObjectWithCriteriaTest.assertNotNull((Object)employee);
            UnitOfWorkConformReadObjectWithCriteriaTest.assertNotNull((Object)employee.getManager());
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        this.queryToExecute = new ReadObjectQuery(Employee.class, builder);
        Expression expression = builder.get("lastName").equal(builder.getParameter("employeeLastName"));
        expression = expression.and(builder.get("manager").get("id").equal(builder.getParameter("managerId")));
        this.queryToExecute.setSelectionCriteria(expression);
        this.queryToExecute.conformResultsInUnitOfWork();
        this.queryToExecute.addArgument("managerId", BigDecimal.class);
        this.queryToExecute.addArgument("employeeLastName", String.class);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
    }

    public void test() {
        for (Employee sampleEmployee : this.employees) {
            Employee sampleManager = (Employee)sampleEmployee.getManager();
            Vector<Object> args = new Vector<Object>();
            args.add(sampleEmployee.getManager().getId());
            args.add(sampleEmployee.getLastName());
            Employee employeeResult = (Employee)this.uow.executeQuery((DatabaseQuery)this.queryToExecute, args);
            UnitOfWorkConformReadObjectWithCriteriaTest.assertNotNull((String)"Employee should not be null", (Object)employeeResult);
            Employee managerResult = (Employee)employeeResult.getManager();
            UnitOfWorkConformReadObjectWithCriteriaTest.assertNotNull((String)"Manager should not be null", (Object)managerResult);
            UnitOfWorkConformReadObjectWithCriteriaTest.assertEquals((String)"The returned Employee should have the same id as the sample Employee", (Object)sampleEmployee.getId(), (Object)employeeResult.getId());
            UnitOfWorkConformReadObjectWithCriteriaTest.assertEquals((String)"The manager of the returned Employee should have the same id as the manager of the sample Employee", (Object)sampleManager.getId(), (Object)managerResult.getId());
        }
    }

    public void reset() {
        if (this.uow != null) {
            this.uow.release();
            this.uow = null;
            this.queryToExecute = null;
            this.employees = null;
        }
    }
}

