/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class ServerClientNamedQueryTest
extends AutoVerifyTestCase {
    private DatabaseLogin login = null;
    private Server serverSession = null;
    private ClientSession clientSession = null;
    private QueryException caughtException = null;

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession(1, 1);
        this.serverSession.useReadConnectionPool(1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        this.clientSession = this.serverSession.acquireClientSession();
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression firstNameExpression = emp.get("firstName").equal(emp.getParameter("firstName"));
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(firstNameExpression);
        query.addArgument("firstName");
        this.serverSession.addQuery("serverClientNamedQuery", (DatabaseQuery)query);
    }

    public void test() {
        try {
            Vector vector = (Vector)this.clientSession.executeQuery("serverClientNamedQuery", (Object)"Jill");
        }
        catch (QueryException exception) {
            this.caughtException = exception;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("A query added to the Server Session could not be found on the Client Session. Error message: " + this.caughtException.toString());
        }
    }

    public void reset() {
        this.serverSession.removeQuery("serverClientNamedQuery");
        this.clientSession.release();
        this.serverSession.logout();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

