/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QueryByExampleInUOWTest
extends TestCase {
    private Employee m_empToCheck;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().rollbackTransaction();
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.conformResultsInUnitOfWork();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee emp = (Employee)uow.registerObject((Object)new Employee());
        emp.setId(new BigDecimal("75"));
        emp.setFirstName("Guy");
        emp.setLastName("Pelletier");
        query.setExampleObject((Object)emp);
        this.m_empToCheck = (Employee)uow.executeQuery((DatabaseQuery)query);
        uow.commit();
    }

    protected void verify() {
        if (this.m_empToCheck == null || this.m_empToCheck.getId().doubleValue() != 75.0 || !this.m_empToCheck.getFirstName().equals("Guy") || !this.m_empToCheck.getLastName().equals("Pelletier")) {
            throw new TestErrorException("The employee returned was null. That is, was not found by the query");
        }
    }
}

