/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class PessimisticLockJoinedAttributeTest
extends TestCase {
    public UnitOfWork uow;
    public short lockMode = (short)2;
    CMPPolicy oldCMPPolicy;

    public PessimisticLockJoinedAttributeTest() {
        this.setDescription("For bug 3422202 verifies the pessimistic locking feature works properly when set on the descriptor and joined attributes are involved.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode(this.lockMode);
        CMPPolicy cmpPolicy = new CMPPolicy();
        cmpPolicy.setPessimisticLockingPolicy(policy);
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(Project.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        this.oldCMPPolicy = employeeDescriptor.getCMPPolicy();
        employeeDescriptor.setCMPPolicy(cmpPolicy);
        employeeDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).setLockMode((short)-1);
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        addressDescriptor.setCMPPolicy(cmpPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.uow != null) {
            this.uow.release();
        }
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(Project.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).dontRefreshIdentityMapResult();
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        employeeDescriptor.setCMPPolicy(this.oldCMPPolicy);
        employeeDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).dontRefreshIdentityMapResult();
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        addressDescriptor.setCMPPolicy(this.oldCMPPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
    }

    public void test() throws Exception {
        if (!this.getSession().getPlatform().isOracle() && !this.getSession().getPlatform().isSQLServer()) {
            throw new TestWarningException("This test only runs on Oracle wears writes do not block reads.");
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(LargeProject.class);
        Expression expression = query.getExpressionBuilder().get("teamLeader").get("firstName").equal((Object)"Charles");
        query.setSelectionCriteria(expression);
        query.addJoinedAttribute(query.getExpressionBuilder().get("teamLeader"));
        query.addJoinedAttribute(query.getExpressionBuilder().get("teamLeader").get("address"));
        Object result = this.uow.executeQuery((DatabaseQuery)query);
        Employee charles = (Employee)((LargeProject)result).getTeamLeader();
        Address address = charles.getAddress();
        ReadObjectQuery cacheQuery = null;
        Object cachedObject = null;
        cacheQuery = new ReadObjectQuery(Address.class);
        cacheQuery.checkCacheThenDatabase();
        cachedObject = this.uow.executeQuery((DatabaseQuery)cacheQuery);
        if (address != cachedObject) {
            throw new TestErrorException("Did not get a cache hit after pessimistically locking a nested joined attribute.");
        }
        cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheThenDatabase();
        cachedObject = this.uow.executeQuery((DatabaseQuery)cacheQuery);
        if (charles != cachedObject) {
            throw new TestErrorException("Did not get a cache hit after pessimisticly locking a joined attribute.");
        }
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        try {
            boolean isLocked = false;
            query = new ReadObjectQuery(LargeProject.class);
            expression = query.getExpressionBuilder().get("teamLeader").get("firstName").equal((Object)"Charles");
            query.setSelectionCriteria(expression);
            LargeProject result2 = (LargeProject)uow2.executeQuery((DatabaseQuery)query);
            try {
                result2.getTeamLeader();
            }
            catch (EclipseLinkException exception) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Triggering an attribute that was locked by another in a joined read should trigger a no_wait exception.");
            }
            Employee originalCharles = (Employee)this.uow.getOriginalVersionOfObject((Object)charles);
            this.uow.release();
            this.uow = null;
            originalCharles.setSalary(0);
            try {
                charles = (Employee)result2.getTeamLeader();
                address = charles.getAddress();
            }
            catch (EclipseLinkException exception) {
                throw new TestErrorException("Now that a joined attribute locked by UOW1 has been released it should be readable now.");
            }
            if (charles.getSalary() == 0) {
                throw new TestErrorException("When a joined attribute is locked by another after it is released, should get refreshed.");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
        }
    }
}

