/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllvsJoinBatchTest
extends PerformanceComparisonTestCase {
    public ReadAllvsJoinBatchTest() {
        this.setDescription("This test compares the performance of read all and access to a 1-1 vs joining and batching.");
        this.addReadAllJoinTest();
        this.addReadAllBatchTest();
    }

    public void test() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector results = this.getSession().readAllObjects(Employee.class);
        for (int index = 0; index < results.size(); ++index) {
            Employee employee = (Employee)results.get(index);
            Address address = employee.getAddress();
        }
    }

    public void addReadAllJoinTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.addJoinedAttribute("address");
                List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (int index = 0; index < results.size(); ++index) {
                    Employee employee = (Employee)results.get(index);
                    Address address = employee.getAddress();
                }
            }
        };
        test.setName("ReadAllJoinTest");
        test.setAllowableDecrease(200.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllBatchTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.addBatchReadAttribute("address");
                List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (int index = 0; index < results.size(); ++index) {
                    Employee employee = (Employee)results.get(index);
                    Address address = employee.getAddress();
                }
            }
        };
        test.setName("ReadAllBatchTest");
        test.setAllowableDecrease(200.0);
        this.addTest((TestCase)test);
    }
}

