/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Vector;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.UnitOfWorkQueryCacheTest;

public class ConformingQueryCacheTest
extends UnitOfWorkQueryCacheTest {
    public ConformingQueryCacheTest() {
        this.setDescription("Ensure results can be conformed when a cached query is run in a UnitOfWork.");
    }

    @Override
    public ReadQuery getQueryForTest() {
        ReadQuery query = super.getQueryForTest();
        ((ObjectLevelReadQuery)query).conformResultsInUnitOfWork();
        return query;
    }

    @Override
    public void test() {
        super.test();
        Employee emp = (Employee)((Vector)this.results).firstElement();
        emp.setFirstName("Modified");
        Employee newEmp = new Employee();
        newEmp.setFirstName("Brooks");
        newEmp.setLastName("Hatlen");
        ((UnitOfWork)this.getSessionForQueryTest()).registerObject((Object)newEmp);
        this.results = this.getSessionForQueryTest().executeQuery("cachedResultsQuery");
    }

    @Override
    public void verify() {
        super.verify();
        for (Employee emp : (Vector)this.results) {
            if (emp.getFirstName().startsWith("B")) continue;
            throw new TestErrorException("Employee returned from cached query results does not conform.");
        }
    }
}

