/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class BatchWritingFlushQueryTest
extends TestCase {
    protected QuerySQLTracker tracker = null;
    protected String firstName = "";
    protected boolean usesBatchWriting;
    protected boolean usesJDBCBatchWriting;
    protected DataModifyQuery myDataModifyQueryObj1;
    protected DataModifyQuery myDataModifyQueryObj2;
    protected int initialSQLStatements = 0;
    protected int initialQueries = 0;
    protected int secondSQLStatements = 0;
    protected int secondQueries = 0;
    protected int EXPECTED_INITIAL_STATEMENTS = 0;
    protected int EXPECTED_INITIAL_QUERIES = 1;
    protected int EXPECTED_SECOND_STATEMENTS = 4;
    protected int EXPECTED_SECOND_QUERIES = 2;

    public BatchWritingFlushQueryTest() {
        this.setDescription("Test for the setForceBatchStatementExecution ModifyQuery option on Dynamic batch writing mechanism.");
    }

    public void setup() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        org.eclipse.persistence.platform.database.DatabasePlatform platform = this.getSession().getPlatform();
        this.usesBatchWriting = platform.usesBatchWriting();
        this.usesJDBCBatchWriting = platform.usesJDBCBatchWriting();
        if (!(platform.isSybase() || platform.isSQLAnywhere() || platform.isOracle() || platform.isSQLServer() || platform.isAttunity())) {
            throw new TestWarningException("Batch writing not supported on platform " + (DatabasePlatform)platform);
        }
        platform.setUsesBatchWriting(true);
        platform.setUsesJDBCBatchWriting(false);
        Employee e = (Employee)session.readObject(Employee.class, new ExpressionBuilder().get("lastName").equal((Object)"Smith"));
        this.firstName = e.firstName;
        session.beginTransaction();
        this.tracker = new QuerySQLTracker((Session)session);
    }

    public void reset() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        org.eclipse.persistence.platform.database.DatabasePlatform platform = this.getSession().getPlatform();
        if (platform.isSybase() || platform.isSQLAnywhere() || platform.isOracle() || platform.isSQLServer() || platform.isAttunity()) {
            platform.setUsesBatchWriting(this.usesBatchWriting);
            platform.setUsesJDBCBatchWriting(this.usesJDBCBatchWriting);
        }
        this.tracker.remove();
        session.rollbackTransaction();
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.myDataModifyQueryObj1 = new DataModifyQuery("UPDATE EMPLOYEE SET F_NAME = 'Fatima?' WHERE L_NAME = 'Smith'");
        this.myDataModifyQueryObj2 = new DataModifyQuery("UPDATE EMPLOYEE SET F_NAME = 'Fatima2?' WHERE L_NAME = 'Smith'");
        uow.executeQuery((DatabaseQuery)this.myDataModifyQueryObj1);
        this.initialSQLStatements = this.tracker.getSqlStatements().size();
        this.initialQueries = this.tracker.getQueries().size();
        this.myDataModifyQueryObj2.setForceBatchStatementExecution(true);
        uow.executeQuery((DatabaseQuery)this.myDataModifyQueryObj2);
        this.secondSQLStatements = this.tracker.getSqlStatements().size();
        this.secondQueries = this.tracker.getQueries().size();
        uow.commit();
    }

    public void verify() {
        if (this.initialSQLStatements != this.EXPECTED_INITIAL_STATEMENTS) {
            throw new TestErrorException("A DataModifyQuery with batchWriting executed resulting in incorrect number of SQL Statements.  expected: " + this.EXPECTED_INITIAL_STATEMENTS + " got: " + this.initialSQLStatements);
        }
        if (this.initialQueries != this.EXPECTED_INITIAL_QUERIES) {
            throw new TestErrorException("A DataModifyQuery with batchWriting executed resulting in incorrect number of Queries.  expected: " + this.EXPECTED_INITIAL_QUERIES + " got: " + this.initialQueries);
        }
        if (this.secondSQLStatements != this.EXPECTED_SECOND_STATEMENTS) {
            throw new TestErrorException("A DataModifyQuery with batchWriting executed resulting in the incorrect number of SQL statements.  expected: " + (this.EXPECTED_SECOND_STATEMENTS - this.EXPECTED_INITIAL_STATEMENTS) + " got: " + (this.secondSQLStatements - this.initialSQLStatements));
        }
        if (this.secondQueries != this.EXPECTED_SECOND_QUERIES) {
            throw new TestErrorException("A DataModifyQuery with batchWriting executed resulting in an incorrect number of Queries.  expected: " + (this.EXPECTED_SECOND_QUERIES - this.EXPECTED_INITIAL_QUERIES) + " got: " + (this.secondQueries - this.initialQueries));
        }
    }
}

