/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.stream.StreamSupport;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.junit.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndirectSetTest {
    private Vector<String> list;
    private IndirectSet<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectSet> cls;
    private boolean useListener;

    @Parameterized.Parameters(name="{0}, {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({IndirectSet.class, true}, {IndirectSet.class, false}, {S.class, true}, {S.class, false});
    }

    public IndirectSetTest(Class<? extends IndirectSet> cls, boolean useListener) {
        this.cls = cls;
        this.useListener = useListener;
    }

    @Before
    public void setUp() {
        this.list = this.setUpList();
        HashSet<String> temp = new HashSet<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectSet();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @After
    public void tearDown() {
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    @Test
    public void testAdd() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    @Test
    public void testAddAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    @Test
    public void testClear() {
        int originalSize = this.testList.size();
        this.list.clear();
        this.testList.clear();
        Assert.assertEquals(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((boolean)this.testList.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.testList.contains((Object)this.list.elementAt(1)));
        this.assertNoEvents();
    }

    @Test
    public void testContainsAll() {
        Assert.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
        this.assertNoEvents();
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.testList.equals(new HashSet<String>(this.list)));
        this.assertNoEvents();
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    @Test
    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        Assert.assertEquals((long)this.list.size(), (long)i);
        this.assertNoEvents();
    }

    @Test
    public void testRemove() {
        String temp = "one";
        Assert.assertTrue((boolean)this.list.remove(temp));
        Assert.assertTrue((boolean)this.testList.remove((Object)temp));
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        Assert.assertTrue((boolean)this.list.removeAll(temp));
        Assert.assertTrue((boolean)this.testList.removeAll(temp));
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(2);
    }

    @Test
    public void testRetainAll() {
        int originalSize = this.testList.size();
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        Assert.assertTrue((boolean)this.list.retainAll(temp));
        Assert.assertTrue((boolean)this.testList.retainAll(temp));
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        Assert.assertTrue((boolean)this.testList.containsAll(temp));
        Assert.assertEquals((long)temp.size(), (long)this.testList.size());
        this.assertRemoveEvents(originalSize - temp.size());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.list.size(), (long)this.testList.size());
        this.assertNoEvents();
    }

    @Test
    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        ZTestCase.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    @Test
    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        ZTestCase.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    @Test
    public void testSpliterator() {
        Assert.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    @Test
    public void testStream() {
        Assert.assertTrue((boolean)this.testList.stream().allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)this.list.stream().allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    @Test
    public void testParallelStream() {
        Assert.assertTrue((boolean)this.testList.parallelStream().allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)this.list.parallelStream().allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    @Test
    public void testRemoveIf() {
        Assert.assertTrue((boolean)this.list.removeIf(item -> item.startsWith("s")));
        Assert.assertTrue((boolean)this.testList.removeIf(item -> item.startsWith("s")));
        Assert.assertEquals((String)"size do not match", (long)8L, (long)this.testList.size());
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        this.assertRemoveEvents(2);
    }

    @Test
    public void testForEach() {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        this.list.forEach(v1::add);
        this.testList.forEach(v2::add);
        ZTestCase.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        ZTestCase.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    private void assertNoEvents() {
        if (this.useListener) {
            Assert.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)0L, (long)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)1L, (long)cce.getChangeType());
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }

    public static final class S<E>
    extends IndirectSet<E> {
    }
}

