/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.List;
import junit.framework.Test;
import org.eclipse.persistence.platform.database.SymfowarePlatform;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.AbstractSchemaIdentifierEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.AbstractSchemaIdentifierNotEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.AggregateTest;
import org.eclipse.persistence.testing.tests.jpql.BinaryOperatorTest;
import org.eclipse.persistence.testing.tests.jpql.BinaryOperatorWithParameterTest;
import org.eclipse.persistence.testing.tests.jpql.ChangeJPQLStringAfterExecutionTest;
import org.eclipse.persistence.testing.tests.jpql.CollectionMemberIdentifierEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.CollectionMemberIdentifierNotEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.ConformResultsInUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.jpql.CustomQueryStringTranlateValidationTest;
import org.eclipse.persistence.testing.tests.jpql.DistinctTest;
import org.eclipse.persistence.testing.tests.jpql.IdentifierTest;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;
import org.eclipse.persistence.testing.tests.jpql.ModTest;
import org.eclipse.persistence.testing.tests.jpql.OrderByTest;
import org.eclipse.persistence.testing.tests.jpql.SelectCOUNTOneToOneTest;
import org.eclipse.persistence.testing.tests.jpql.SelectOneToOneTest;
import org.eclipse.persistence.testing.tests.jpql.SelectPhoneNumberDeclaredInINClauseTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleAbsTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleApostropheTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleBetweenAndTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleBetweenTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleConcatTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleConcatTestWithConstantsLiteralFirst;
import org.eclipse.persistence.testing.tests.jpql.SimpleConcatTestWithConstantsLiteralSecond;
import org.eclipse.persistence.testing.tests.jpql.SimpleDoubleOrTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleEqualsBracketsTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleEqualsTestWithJoin;
import org.eclipse.persistence.testing.tests.jpql.SimpleEqualsTestWithManualJoin;
import org.eclipse.persistence.testing.tests.jpql.SimpleEqualsWithAs;
import org.eclipse.persistence.testing.tests.jpql.SimpleEscapeUnderscoreTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleFromFailed;
import org.eclipse.persistence.testing.tests.jpql.SimpleInOneDotTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleInOneDotTestReversed;
import org.eclipse.persistence.testing.tests.jpql.SimpleInTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleIsEmptyTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleIsNotEmptyTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleLengthTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleLikeTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleLikeTestWithParameter;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotBetweenTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotEqualsTwoVariables;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotEqualsVariablesIngeter;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotInTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotLikeTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleNotNullTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleNullTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleOrFollowedByAndTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleOrFollowedByAndTestWithStaticNames;
import org.eclipse.persistence.testing.tests.jpql.SimpleOrTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleParameterTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleParameterTestChangingParameters;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseAbsTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseConcatTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseEqualsTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseLengthTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseParameterTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseSqrtTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleReverseSubstringTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleSqrtTest;
import org.eclipse.persistence.testing.tests.jpql.SimpleSubstringTest;
import org.eclipse.persistence.testing.tests.jpql.SmallProjectMemberOfProjectsTest;
import org.eclipse.persistence.testing.tests.jpql.SmallProjectNOTMemberOfProjectsTest;
import org.eclipse.persistence.testing.tests.jpql.WhitespaceTest;

public class JPQLSimpleTestSuite
extends TestSuite {
    public JPQLSimpleTestSuite() {
        this.setDescription("The unit tests for EJBQL");
    }

    public void addTests() {
        this.addTest((Test)JPQLTestCase.getBaseTestCase());
        this.addSpecialTest(new SimpleAbsTest());
        this.addTest((Test)new SimpleBetweenAndTest());
        this.addTest((Test)new SimpleBetweenTest());
        this.addTest((Test)new SimpleConcatTest());
        this.addTest((Test)new SimpleConcatTestWithConstantsLiteralSecond());
        this.addTest((Test)new SimpleConcatTestWithConstantsLiteralFirst());
        this.addTest((Test)new SimpleDoubleOrTest());
        this.addTest((Test)new SimpleEqualsBracketsTest());
        this.addTest((Test)new SimpleEqualsTest());
        this.addTest((Test)new SimpleEqualsTestWithJoin());
        this.addTest((Test)new SimpleEqualsTestWithManualJoin());
        this.addTest((Test)new SimpleEqualsWithAs());
        this.addTest((Test)new CollectionMemberIdentifierEqualsTest());
        this.addTest((Test)new CollectionMemberIdentifierNotEqualsTest());
        this.addTest((Test)new AbstractSchemaIdentifierEqualsTest());
        this.addTest((Test)new AbstractSchemaIdentifierNotEqualsTest());
        this.addTest((Test)new SimpleFromFailed());
        this.addTest((Test)new SimpleInOneDotTest());
        this.addTest((Test)new SimpleInOneDotTestReversed());
        this.addTest((Test)new SimpleInTest());
        this.addTest((Test)new SimpleLengthTest());
        this.addTest((Test)new SimpleLikeTest());
        this.addTest((Test)new SimpleLikeTestWithParameter());
        this.addTest((Test)new SimpleNotBetweenTest());
        this.addTest((Test)new SimpleNotEqualsTwoVariables());
        this.addTest((Test)new SimpleNotEqualsVariablesIngeter());
        this.addTest((Test)new SimpleNotInTest());
        this.addTest((Test)new SimpleNotLikeTest());
        this.addTest((Test)new SimpleOrFollowedByAndTest());
        this.addTest((Test)new SimpleOrFollowedByAndTestWithStaticNames());
        this.addTest((Test)new SimpleOrTest());
        this.addTest((Test)new SimpleParameterTest());
        this.addTest((Test)new SimpleParameterTestChangingParameters());
        this.addSpecialTest(new SimpleReverseAbsTest());
        this.addTest((Test)new SimpleReverseConcatTest());
        this.addTest((Test)new SimpleReverseEqualsTest());
        this.addTest((Test)new SimpleReverseLengthTest());
        this.addTest((Test)new SimpleReverseParameterTest());
        this.addSpecialTest2(new SimpleReverseSqrtTest());
        this.addTest((Test)new SimpleReverseSubstringTest());
        this.addSpecialTest2(new SimpleSqrtTest());
        this.addTest((Test)new SimpleSubstringTest());
        this.addTest((Test)new SimpleNullTest());
        this.addTest((Test)new SimpleNotNullTest());
        this.addTest((Test)new SimpleOrFollowedByAndTest());
        this.addTest((Test)new SimpleNotEqualsVariablesIngeter());
        this.addTest((Test)new SimpleBetweenAndTest());
        this.addTest((Test)new SimpleInOneDotTest());
        this.addTest((Test)new SimpleEqualsBracketsTest());
        this.addTest((Test)new SimpleEqualsWithAs());
        this.addTest((Test)new DistinctTest());
        this.addTest((Test)new ConformResultsInUnitOfWorkTest());
        this.addTest((Test)ModTest.getSimpleModTest());
        this.addSpecialTest(new SimpleIsEmptyTest());
        this.addSpecialTest(new SimpleIsNotEmptyTest());
        this.addTest((Test)new SimpleApostropheTest());
        this.addTest((Test)new SimpleEscapeUnderscoreTest());
        this.addTest((Test)new SmallProjectMemberOfProjectsTest());
        this.addTest((Test)new SmallProjectNOTMemberOfProjectsTest());
        this.addTest((Test)new SelectCOUNTOneToOneTest());
        this.addTest((Test)new SelectOneToOneTest());
        this.addTest((Test)new SelectPhoneNumberDeclaredInINClauseTest());
        IdentifierTest.addTestsTo(this);
        this.addTest((Test)WhitespaceTest.getWhitespaceTests());
        this.addTest((Test)BinaryOperatorTest.getSimpleBinaryOperatorTests());
        this.addTest((Test)BinaryOperatorWithParameterTest.getParameterBinaryOperatorTests());
        this.addTest((Test)OrderByTest.getOrderByTestSuite());
        this.addTest((Test)AggregateTest.getSimpleAggregateTestSuite());
        this.addTest((Test)new ChangeJPQLStringAfterExecutionTest());
        this.addTest((Test)this.buildMaxRowsTest());
        this.addTest((Test)new CustomQueryStringTranlateValidationTest());
    }

    public TestCase buildMaxRowsTest() {
        return new TestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setEJBQLString("Select Object(Emp) from Employee Emp");
                List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                if (results.size() != 12) {
                    this.throwError("Incorrect number of employees:12->" + results.size());
                }
                if ((results = (List)this.getSession().executeQuery((DatabaseQuery)query)).size() != 12) {
                    this.throwError("Incorrect number of employees:12->" + results.size());
                }
                query = new ReadAllQuery(Employee.class);
                query.setEJBQLString("Select Object(Emp) from Employee Emp");
                query.setMaxRows(5);
                results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                if (results.size() != 5) {
                    this.throwError("Incorrect number of employees:5->" + results.size());
                }
            }
        };
    }

    public void addSpecialTest(JPQLTestCase theTest) {
        theTest.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)theTest);
    }

    public void addSpecialTest2(JPQLTestCase theTest) {
        theTest.addUnsupportedPlatform(TimesTenPlatform.class);
        theTest.addUnsupportedPlatform(SymfowarePlatform.class);
        this.addTest((Test)theTest);
    }
}

