/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class UnitOfWorkExpiredObjectTest
extends CacheExpiryTest {
    protected Employee employee = null;
    protected String firstName = null;

    public UnitOfWorkExpiredObjectTest() {
        this.setDescription("Ensure expired objects are still usable on a UnitOfWork.");
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.readObject((Object)this.employee);
        uow.getIdentityMapAccessor().invalidateObject((Object)employeeClone);
        employeeClone.setFirstName(this.employee.getFirstName() + "-mutated");
        this.firstName = employeeClone.getFirstName();
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.employee = (Employee)this.getSession().readObject((Object)this.employee);
    }

    public void verify() {
        if (!this.employee.getFirstName().equals(this.firstName)) {
            throw new TestErrorException("Using an employee in a UnitOfWork after invalidating it failed.");
        }
    }
}

