/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class RefreshQueryCacheExpiryTest
extends CacheExpiryTest {
    protected Vector employees = null;
    protected Vector employeeNames = null;

    public RefreshQueryCacheExpiryTest() {
        this.setDescription("Ensure refresh queries correcly refresh both the object and the expiry time");
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000L));
        this.employees = this.getSession().readAllObjects(Employee.class);
        this.employeeNames = new Vector();
    }

    public void test() {
        Enumeration empEnum = this.employees.elements();
        while (empEnum.hasMoreElements()) {
            CacheKey key = this.getAbstractSession().getIdentityMapAccessorInstance().getCacheKeyForObject(empEnum.nextElement());
            this.employeeNames.addElement(((Employee)key.getObject()).getFirstName());
            ((Employee)key.getObject()).setFirstName(((Employee)key.getObject()).getFirstName() + "-mutated");
        }
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.refreshIdentityMapResult();
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        Enumeration empEnum = this.employees.elements();
        while (empEnum.hasMoreElements()) {
            CacheKey key = this.getAbstractSession().getIdentityMapAccessorInstance().getCacheKeyForObject(empEnum.nextElement());
            if (!this.employeeNames.contains(((Employee)key.getObject()).getFirstName())) {
                throw new TestErrorException("Refreshing ReadAllQuery does not properly refresh data when used with Cache Expiry.");
            }
            this.employeeNames.remove(((Employee)key.getObject()).getFirstName());
        }
        if (!this.employeeNames.isEmpty()) {
            throw new TestErrorException("Not all values were returned from the refreshing ReadAllQuery when used with Cache Expiry.");
        }
    }
}

