/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.feature.TestContext;
import org.eclipse.persistence.testing.tests.feature.TestDataSource;

public class JNDIConnectionTest
extends AutoVerifyTestCase {
    Connector connector;

    public JNDIConnectionTest() {
        this.setDescription("Connect to the database using the JNDIConnector");
    }

    public void reset() {
        ((DatabaseSession)this.getSession()).logout();
        this.getSession().getLogin().setConnector(this.connector);
        ((DatabaseSession)this.getSession()).login();
    }

    protected void setup() {
        TestContext context;
        ((DatabaseSession)this.getSession()).logout();
        DatabaseLogin login = this.getSession().getLogin();
        this.connector = login.getConnector();
        String dataSourceName = "JNDI test DataSource";
        TestDataSource dataSource = new TestDataSource(login.getDriverClassName(), login.getConnectionString(), (Properties)login.getProperties().clone());
        try {
            context = new TestContext(dataSourceName, (DataSource)dataSource);
        }
        catch (NamingException e) {
            throw new RuntimeException("JNDI problem");
        }
        login.setConnector((Connector)new JNDIConnector((Context)context, dataSourceName));
    }

    public void test() {
        ((DatabaseSession)this.getSession()).login();
    }

    protected void verify() {
        if (!this.getSession().isConnected()) {
            throw new TestErrorException("Session not connected via JNDI-supplied DataSource.");
        }
    }
}

