/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Iterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.EntityEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;

public class TestUpdateEntityEntityMapMapping
extends TestCase {
    private EntityEntityMapHolder holder = null;
    protected ManyToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldPrivateOwnedValue = false;
    protected ForeignReferenceMapping keyMapping = null;
    private boolean oldKeyPrivateOwnedValue = false;
    protected EntityEntityMapHolder changedHolder = null;

    public TestUpdateEntityEntityMapMapping() {
    }

    public TestUpdateEntityEntityMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateEntityEntityMapMapping privateOwned=" + usePrivateOwned);
    }

    public void setup() {
        this.mapping = (ManyToManyMapping)this.getSession().getProject().getDescriptor(EntityEntityMapHolder.class).getMappingForAttributeName("entityToEntityMap");
        this.oldPrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        this.keyMapping = (ForeignReferenceMapping)((MappedKeyMapContainerPolicy)this.mapping.getContainerPolicy()).getKeyMapping();
        this.oldKeyPrivateOwnedValue = this.keyMapping.isPrivateOwned();
        this.keyMapping.setIsPrivateOwned(this.usePrivateOwned);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = new EntityEntityMapHolder();
        EntityMapValue value = new EntityMapValue();
        value.setId(1);
        EntityMapKey key = new EntityMapKey();
        key.setId(11);
        key.setData("data1");
        this.holder.addEntityToEntityMapItem(key, value);
        uow.registerObject((Object)key);
        EntityMapValue value2 = new EntityMapValue();
        value2.setId(2);
        key = new EntityMapKey();
        key.setId(22);
        this.holder.addEntityToEntityMapItem(key, value2);
        uow.registerObject((Object)this.holder);
        uow.registerObject((Object)key);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.changedHolder = (EntityEntityMapHolder)uow.readObject((Object)this.holder);
        EntityMapValue value = new EntityMapValue();
        value.setId(3);
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(33);
        EntityMapKey clonedKey = (EntityMapKey)uow.registerObject((Object)mapKey);
        this.changedHolder.addEntityToEntityMapItem(clonedKey, value);
        mapKey = new EntityMapKey();
        mapKey.setId(11);
        this.changedHolder.getEntityToEntityMap().remove(mapKey);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.holder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.holder = (EntityEntityMapHolder)this.getSession().readObject((Object)this.holder);
        if (this.holder == null) {
            throw new TestErrorException("AggregateKeyMapHolder could not be read.");
        }
        if (!this.compareObjects(this.holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (this.holder.getEntityToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(33);
        EntityMapValue value = (EntityMapValue)this.holder.getEntityToEntityMap().get(mapKey);
        if (value.getId() != 3) {
            throw new TestErrorException("MapEntityValue was not added properly.");
        }
        mapKey = new EntityMapKey();
        mapKey.setId(11);
        value = (EntityMapValue)this.holder.getEntityToEntityMap().get(mapKey);
        if (value != null) {
            throw new TestErrorException("Deleted EntityMapValue still around.");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EntityMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned EntityMapValue was not deleted.");
            }
            query = new ReadObjectQuery(EntityMapKey.class);
            ExpressionBuilder keys = new ExpressionBuilder();
            Expression keycriteria = keys.get("id").equal(11);
            query.setSelectionCriteria(keycriteria);
            EntityMapKey key = (EntityMapKey)this.getSession().executeQuery((DatabaseQuery)query);
            if (key != null) {
                throw new TestErrorException("PrivateOwned EntityMapKey was not deleted.");
            }
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Iterator j = this.holder.getEntityToEntityMap().keySet().iterator();
        while (j.hasNext()) {
            uow.deleteObject(this.holder.getEntityToEntityMap().get(j.next()));
        }
        uow.deleteObject((Object)this.holder);
        uow.commit();
        this.mapping.setIsPrivateOwned(this.oldPrivateOwnedValue);
        this.keyMapping.setIsPrivateOwned(this.oldKeyPrivateOwnedValue);
    }
}

