/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.readonly;

import java.util.Collection;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.readonly.Actor;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Charity;
import org.eclipse.persistence.testing.models.readonly.Country;
import org.eclipse.persistence.testing.models.readonly.DefaultReadOnlyTestClass;
import org.eclipse.persistence.testing.models.readonly.HollywoodAgent;
import org.eclipse.persistence.testing.models.readonly.Movie;
import org.eclipse.persistence.testing.models.readonly.Promoter;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyProject;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class ReadOnlySystem
extends TestSystem {
    public ReadOnlySystem() {
        this.project = new ReadOnlyProject();
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new ReadOnlyProject();
        }
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)Promoter.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Actor.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Actor.actorMovieJoinTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Actor.actorCharityJoinTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Address.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Charity.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)HollywoodAgent.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Movie.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Country.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)DefaultReadOnlyTestClass.tableDefinition());
        schemaManager.createSequences();
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        Movie movie1 = Movie.example1();
        Movie movie2 = Movie.example2();
        Movie movie3 = Movie.example3();
        Movie movie4 = Movie.example4();
        Movie movie5 = Movie.example5();
        unitOfWork.registerObject((Object)movie1);
        unitOfWork.registerObject((Object)movie2);
        unitOfWork.registerObject((Object)movie3);
        unitOfWork.registerObject((Object)movie4);
        unitOfWork.registerObject((Object)movie5);
        manager.registerObject((Object)movie1, "movie1");
        manager.registerObject((Object)movie2, "movie2");
        manager.registerObject((Object)movie3, "movie3");
        manager.registerObject((Object)movie4, "movie4");
        manager.registerObject((Object)movie4, "movie5");
        unitOfWork.registerAllObjects((Collection)Country.countries());
        unitOfWork.registerAllObjects((Collection)HollywoodAgent.hollywoodAgents());
        unitOfWork.registerAllObjects((Collection)Charity.charities());
        unitOfWork.commit();
    }
}

