/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.unit;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;

public class EMFProviderTest
extends TestCase {
    private final Map<String, String> overrides = new HashMap<String, String>();

    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("eclipselink.testProp", "elTestPropValue");
        System.setProperty("javax.persistence.testProp", "jxpTestPropValue");
        System.setProperty("persistence.testProp", "perTestPropValue");
        System.setProperty("INTERACT_WITH_DB", "dbTestPropValue");
        System.setProperty("java.testProp", "should not be able to read this!");
        this.overrides.put("java.testProp", "some/path");
        this.overrides.put("eclipselink.testProp", "elOverride");
        this.overrides.put("javax.persistence.testProp", "jxpOverride");
        this.overrides.put("persistence.testProp", "perOverride");
        this.overrides.put("INTERACT_WITH_DB", "dbOverride");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        for (String propKey : this.overrides.keySet()) {
            System.clearProperty(propKey);
        }
        EMFProviderTest.assertNull((Object)System.getProperty("java.testProp"));
        EMFProviderTest.assertNull((Object)System.getProperty("eclipselink.testProp"));
        EMFProviderTest.assertNull((Object)System.getProperty("javax.persistence.testProp"));
        EMFProviderTest.assertNull((Object)System.getProperty("persistence.testProp"));
        EMFProviderTest.assertNull((Object)System.getProperty("INTERACT_WITH_DB"));
    }

    public void testGetConfigProperty() {
        EMFProviderTest.assertEquals((String)"elTestPropValue", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"eclipselink.testProp", null));
        EMFProviderTest.assertEquals((String)"jxpTestPropValue", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"javax.persistence.testProp", null));
        EMFProviderTest.assertEquals((String)"perTestPropValue", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"persistence.testProp", null));
        EMFProviderTest.assertEquals((String)"dbTestPropValue", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"INTERACT_WITH_DB", null));
        try {
            EMFProviderTest.assertEquals((String)"should not be able to read this!", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"java.testProp", null));
            EMFProviderTest.fail((String)"should not read JVM property");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EMFProviderTest.assertEquals((String)"elOverride", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"eclipselink.testProp", this.overrides));
        EMFProviderTest.assertEquals((String)"jxpOverride", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"javax.persistence.testProp", this.overrides));
        EMFProviderTest.assertEquals((String)"perOverride", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"persistence.testProp", this.overrides));
        EMFProviderTest.assertEquals((String)"dbOverride", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"INTERACT_WITH_DB", this.overrides));
        EMFProviderTest.assertEquals((String)"some/path", (String)EntityManagerFactoryProvider.getConfigPropertyAsString((String)"java.testProp", this.overrides));
    }
}

