/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.weave.IsolatedEntity;
import org.eclipse.persistence.testing.models.jpa.weave.Location;
import org.eclipse.persistence.testing.models.jpa.weave.Node;
import org.eclipse.persistence.testing.models.jpa.weave.Order;

public class WeaveVersionTestSuite
extends JUnitTestCase {
    private static final String NODE_01 = "NODE_01";
    private static final String LOCATION_01 = "LOCATION_01";
    private static final String PROCESS_01 = "PROCESS_01";

    public WeaveVersionTestSuite() {
    }

    public WeaveVersionTestSuite(String name) {
        super(name);
        this.setPuName(this.getPersistenceUnitName());
    }

    public String getPersistenceUnitName() {
        return "pu-with-dynamic-weaving";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("WeaveVersionTestSuite");
        suite.addTest((Test)new WeaveVersionTestSuite("testWeavedEntitiesWithVersionL2Cache"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Node node = new Node(NODE_01);
            em.persist((Object)node);
            Location destinationLocation = new Location(1L, LOCATION_01);
            destinationLocation.setNode(node);
            em.persist((Object)destinationLocation);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWeavedEntitiesWithVersionL2Cache() {
        Order order;
        IsolatedEntity serialProcess;
        Order order2;
        EntityManagerFactory emf = this.getEntityManagerFactory();
        this.cleanup();
        emf.getCache().evictAll();
        long toKey = 1L;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            order2 = new Order(1L);
            em.persist((Object)order2);
            em.flush();
            Location location = (Location)em.createQuery("SELECT l FROM Location l WHERE l.locationId=:locationId", Location.class).setParameter("locationId", (Object)LOCATION_01).getSingleResult();
            order2.setNode(location.getNode());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        toKey = 1L;
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            serialProcess = new IsolatedEntity(PROCESS_01);
            em.persist((Object)serialProcess);
            em.flush();
            order = (Order)em.find(Order.class, (Object)1L);
            order.getNode().reserveBufferCapacity();
            em.merge((Object)order);
            em.merge((Object)order.getNode());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        this.cleanup();
        emf.getCache().evictAll();
        toKey = 2L;
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            order2 = new Order(2L);
            em.persist((Object)order2);
            em.flush();
            Location destinationLocation = (Location)em.createQuery("SELECT l FROM Location l WHERE l.locationId=:locationId", Location.class).setParameter("locationId", (Object)LOCATION_01).getSingleResult();
            order2.setNode(destinationLocation.getNode());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        toKey = 2L;
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            serialProcess = new IsolatedEntity(PROCESS_01);
            em.persist((Object)serialProcess);
            em.flush();
            order = (Order)em.find(Order.class, (Object)2L);
            order.getNode().reserveBufferCapacity();
            em.merge((Object)order);
            em.merge((Object)order.getNode());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void cleanup() {
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        try {
            em.createQuery("delete from IsolatedEntity s").executeUpdate();
            em.createQuery("delete from Order t").executeUpdate();
            em.createQuery("UPDATE Node tn SET tn.availableBufferCapacity =10").executeUpdate();
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void tearDown() {
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        try {
            em.createQuery("delete from Location l").executeUpdate();
            em.createQuery("delete from Order t").executeUpdate();
            em.createQuery("delete from Node t").executeUpdate();
            em.createQuery("delete from IsolatedEntity s").executeUpdate();
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

