/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.collection;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.runtime.Assert;
import org.eclipse.viatra.addon.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservableCollectionHelper;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservablePatternMatchCollection;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;

public class ObservablePatternMatchSet<Match extends IPatternMatch>
extends AbstractObservableSet {
    private final Set<Object> cache = Collections.synchronizedSet(new HashSet());
    private SetCollectionUpdate updater;
    private RuleSpecification<Match> specification;
    private EventFilter<Match> matchFilter;
    private RuleEngine ruleEngine;
    private boolean privateRuleEngine;
    private ObservablePatternMatchCollection<Match> internalCollection = new ObservablePatternMatchCollection<Match>(){

        @Override
        public void createUpdater(Function<Match, ?> converter, Comparator<Match> comparator) {
            ObservablePatternMatchSet.this.updater = new SetCollectionUpdate(converter);
        }

        @Override
        public void createRuleSpecification(IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification) {
            ObservablePatternMatchSet.this.specification = ObservableCollectionHelper.createRuleSpecification(ObservablePatternMatchSet.this.updater, querySpecification);
        }

        @Override
        public void createRuleSpecification(ViatraQueryMatcher<Match> matcher) {
            ObservablePatternMatchSet.this.specification = ObservableCollectionHelper.createRuleSpecification(ObservablePatternMatchSet.this.updater, matcher);
        }

        @Override
        public void setFilter(EventFilter<Match> filter) {
            if (filter == null) {
                ObservablePatternMatchSet.this.matchFilter = ObservablePatternMatchSet.this.specification.createEmptyFilter();
            } else {
                ObservablePatternMatchSet.this.matchFilter = filter;
            }
        }

        @Override
        public void initialize(ViatraQueryEngine engine) {
            ObservablePatternMatchSet.this.ruleEngine = ObservableCollectionHelper.prepareRuleEngine(engine, ObservablePatternMatchSet.this.specification, ObservablePatternMatchSet.this.matchFilter);
            ObservablePatternMatchSet.this.privateRuleEngine = true;
        }

        @Override
        public void initialize(RuleEngine engine) {
            ObservablePatternMatchSet.this.ruleEngine = engine;
            ObservablePatternMatchSet.this.privateRuleEngine = false;
            ObservablePatternMatchSet.this.ruleEngine.addRule(ObservablePatternMatchSet.this.specification, ObservablePatternMatchSet.this.matchFilter);
            ObservableCollectionHelper.fireActivations(engine, ObservablePatternMatchSet.this.specification, ObservablePatternMatchSet.this.matchFilter);
        }
    };

    protected ObservablePatternMatchSet() {
    }

    protected ObservablePatternMatchCollection<Match> getInternalCollection() {
        return this.internalCollection;
    }

    public Object getElementType() {
        if (this.updater.converter != null) {
            return Object.class;
        }
        return IPatternMatch.class;
    }

    protected Set<Object> getWrappedSet() {
        return this.cache;
    }

    public synchronized void dispose() {
        this.ruleEngine.removeRule(this.specification, this.matchFilter);
        if (this.privateRuleEngine && this.ruleEngine.getRuleSpecificationMultimap().isEmpty()) {
            this.ruleEngine.dispose();
        }
        this.clear();
        super.dispose();
    }

    public void clear() {
        this.cache.clear();
        this.updater.clear();
    }

    public RuleSpecification<Match> getSpecification() {
        return this.specification;
    }

    public class SetCollectionUpdate
    implements IObservablePatternMatchCollectionUpdate<Match> {
        private static final String DATA_BINDING_REALM_MUST_NOT_BE_NULL = "Data binding Realm must not be null";
        protected final Function<Match, ?> converter;
        protected final Map<Match, Object> matchToItem = new HashMap();

        public SetCollectionUpdate(Function<Match, ?> converter) {
            this.converter = converter != null ? converter : null;
        }

        @Override
        public void addMatch(Match match) {
            Object item = match;
            if (this.converter != null) {
                item = this.converter.apply(match);
                this.matchToItem.put(match, item);
            }
            ObservablePatternMatchSet.this.cache.add(item);
            final SetDiff diff = Diffs.createSetDiff((Set)Sets.newHashSet((Object[])new Object[]{item}), (Set)Collections.EMPTY_SET);
            Realm realm = ObservablePatternMatchSet.this.getRealm();
            Assert.isNotNull((Object)realm, (String)DATA_BINDING_REALM_MUST_NOT_BE_NULL);
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchSet.this.isDisposed()) {
                        ObservablePatternMatchSet.this.fireSetChange(diff);
                    }
                }
            });
        }

        @Override
        public void removeMatch(Match match) {
            Object item = match;
            if (this.converter != null) {
                item = this.matchToItem.get(match);
            }
            ObservablePatternMatchSet.this.cache.remove(item);
            final SetDiff diff = Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Sets.newHashSet((Object[])new Object[]{item}));
            Realm realm = ObservablePatternMatchSet.this.getRealm();
            Assert.isNotNull((Object)realm, (String)DATA_BINDING_REALM_MUST_NOT_BE_NULL);
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchSet.this.isDisposed()) {
                        ObservablePatternMatchSet.this.fireSetChange(diff);
                    }
                }
            });
        }

        @Override
        public void clear() {
            this.matchToItem.clear();
        }
    }
}

