/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.team.svn.revision.graph.graphic.MergeConnectionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionConnectionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionSourceAnchor;
import org.eclipse.team.svn.revision.graph.graphic.RevisionTargetAnchor;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionConnectionEditPart;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionGraphEditPart;
import org.eclipse.team.svn.revision.graph.graphic.figure.ExpandCollapseDecoration;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionFigure;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionTooltipFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener {
    protected RevisionFigure revisionFigure;
    protected ExpandCollapseDecoration collapseDecoration;
    protected NodeMouseMotionListener nodeMouseMotionListener;

    public void activate() {
        super.activate();
        this.getCastedModel().addPropertyChangeListener(this);
    }

    public void deactivate() {
        RevisionNode node = this.getCastedModel();
        node.removePropertyChangeListener(this);
        if (this.nodeMouseMotionListener != null) {
            this.revisionFigure.removeMouseMotionListener((MouseMotionListener)this.nodeMouseMotionListener);
        }
        if (this.collapseDecoration != null) {
            this.collapseDecoration.removeDecoration();
        }
        node.removeAllOutgoingMergeConnections();
        node.removeAllIncomingMergeConnections();
        super.deactivate();
    }

    protected IFigure createFigure() {
        RevisionNode revision = this.getCastedModel();
        String path = revision.getPath();
        this.revisionFigure = new RevisionFigure(revision, path);
        this.revisionFigure.setToolTip((IFigure)new RevisionTooltipFigure(revision));
        this.nodeMouseMotionListener = new NodeMouseMotionListener();
        this.revisionFigure.addMouseMotionListener((MouseMotionListener)this.nodeMouseMotionListener);
        IFigure decorationLayer = this.getLayer("Decoration Layer");
        this.collapseDecoration = new ExpandCollapseDecoration(revision, decorationLayer);
        return this.revisionFigure;
    }

    public void applyLayoutResults() {
        RevisionNode node = this.getCastedModel();
        Rectangle bounds = new Rectangle(node.getX(), node.getY(), node.getWidth(), node.getHeight());
        this.revisionFigure.setBounds(bounds);
        this.collapseDecoration.setDecoratedFigure(this.revisionFigure);
    }

    public RevisionFigure getRevisionFigure() {
        return this.revisionFigure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.revisionFigure.init();
    }

    public RevisionRootNode getRevisionRootNode() {
        RevisionRootNode root = ((RevisionGraphEditPart)this.getParent()).getCastedModel();
        return root;
    }

    public RevisionNode getCastedModel() {
        return (RevisionNode)this.getModel();
    }

    protected List<RevisionConnectionNode> getModelSourceConnections() {
        RevisionRootNode root = this.getRevisionRootNode();
        RevisionNode model = this.getCastedModel();
        List<RevisionConnectionNode> connections = root.getConnections(model, true);
        List<MergeConnectionNode> outgoingMerges = model.getOutgoingMergeConnections();
        if (!outgoingMerges.isEmpty()) {
            ArrayList<RevisionConnectionNode> result = new ArrayList<RevisionConnectionNode>(connections);
            result.addAll(outgoingMerges);
            return result;
        }
        return connections;
    }

    protected List<RevisionConnectionNode> getModelTargetConnections() {
        RevisionRootNode root = this.getRevisionRootNode();
        RevisionNode model = this.getCastedModel();
        List<RevisionConnectionNode> connections = root.getConnections(model, false);
        List<MergeConnectionNode> incomingMerges = model.getIncomingMergeConnections();
        if (!incomingMerges.isEmpty()) {
            ArrayList<RevisionConnectionNode> result = new ArrayList<RevisionConnectionNode>(connections);
            result.addAll(incomingMerges);
            return result;
        }
        return connections;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void showSelection() {
                RevisionEditPart.this.revisionFigure.setSelected(true);
            }

            protected void hideSelection() {
                RevisionEditPart.this.revisionFigure.setSelected(false);
            }
        });
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        RevisionConnectionNode conNode = ((RevisionConnectionEditPart)connection).getCastedModel();
        return new RevisionSourceAnchor(this.getFigure(), conNode.getSource(), conNode.getTarget(), conNode instanceof MergeConnectionNode);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        throw new IllegalStateException();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        RevisionConnectionNode conNode = ((RevisionConnectionEditPart)connection).getCastedModel();
        return new RevisionTargetAnchor(this.getFigure(), conNode.getSource(), conNode.getTarget(), conNode instanceof MergeConnectionNode);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        throw new IllegalStateException();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("refreshNodeConnections".equals(evt.getPropertyName())) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        } else if ("expandCollapseOnNode".equals(evt.getPropertyName())) {
            this.collapseDecoration.internalShowExpanded(false);
            this.collapseDecoration.removeDecoration();
        } else if ("refreshMergeSourceConnections".equals(evt.getPropertyName())) {
            this.refreshSourceConnections();
            this.revisionFigure.changeMerges();
        } else if ("refreshMergeTargetConnections".equals(evt.getPropertyName())) {
            this.refreshTargetConnections();
            this.revisionFigure.changeMerges();
        } else if ("truncateNodePath".equals(evt.getPropertyName())) {
            this.revisionFigure.changeTruncatePath();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RevisionEditPart) {
            return this.getCastedModel().equals(((RevisionEditPart)obj).getCastedModel());
        }
        return false;
    }

    public int hashCode() {
        return this.getCastedModel().hashCode();
    }

    protected class NodeMouseMotionListener
    extends MouseMotionListener.Stub {
        protected NodeMouseMotionListener() {
        }

        public void mouseEntered(MouseEvent me) {
            RevisionEditPart.this.collapseDecoration.showExpanded(true);
        }

        public void mouseExited(MouseEvent me) {
            if (!RevisionEditPart.this.collapseDecoration.containsPoint(me.getLocation())) {
                RevisionEditPart.this.collapseDecoration.showExpanded(false);
            }
        }
    }
}

