/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractUnwrappingEList<W, T>
extends AbstractEList<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<T> targetType;
    protected Class<W> wrapperType;
    private List<W> delegateList;

    protected abstract W wrap(T var1) throws CoreException;

    protected abstract T unwrap(W var1);

    public AbstractUnwrappingEList(List<W> delegateList, Class<W> wrapperType, Class<T> targetType) {
        Assert.isNotNull(delegateList);
        Assert.isNotNull(wrapperType);
        Assert.isNotNull(targetType);
        this.delegateList = delegateList;
        this.wrapperType = wrapperType;
        this.targetType = targetType;
    }

    protected List<W> delegateList() {
        return this.delegateList;
    }

    public int size() {
        return this.delegateSize();
    }

    protected int delegateSize() {
        return this.delegateList().size();
    }

    public boolean isEmpty() {
        return this.delegateIsEmpty();
    }

    protected boolean delegateIsEmpty() {
        return this.delegateList().isEmpty();
    }

    public boolean contains(Object object) {
        return this.delegateContains(object);
    }

    protected boolean delegateContains(Object object) {
        return this.delegateList().contains(object);
    }

    public boolean containsAll(Collection<?> collection) {
        return this.delegateContainsAll(collection);
    }

    protected boolean delegateContainsAll(Collection<?> collection) {
        return this.delegateList().containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.delegateIndexOf(object);
    }

    protected int delegateIndexOf(Object object) {
        return this.delegateList().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.delegateLastIndexOf(object);
    }

    protected int delegateLastIndexOf(Object object) {
        return this.delegateList().lastIndexOf(object);
    }

    public Object[] toArray() {
        return this.delegateToArray();
    }

    protected Object[] delegateToArray() {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (W object : this.delegateList()) {
            try {
                result.add(this.unwrap(object));
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return result.toArray();
    }

    public <T1> T1[] toArray(T1[] array) {
        return this.delegateToArray(array);
    }

    protected <T1> T1[] delegateToArray(T1[] array) {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (W object : this.delegateList()) {
            try {
                result.add(this.unwrap(object));
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return result.toArray(array);
    }

    public T get(int index) {
        return (T)this.resolve(index, this.delegateGet(index));
    }

    protected T delegateGet(int index) {
        W object = this.delegateList().get(index);
        try {
            return this.unwrap(object);
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return null;
        }
    }

    protected T basicGet(int index) {
        return this.delegateGet(index);
    }

    protected T primitiveGet(int index) {
        return this.delegateGet(index);
    }

    public T setUnique(int index, T object) {
        Object oldObject = this.delegateSet(index, this.validate(index, object));
        this.didSet(index, object, oldObject);
        this.didChange();
        return (T)oldObject;
    }

    protected T delegateSet(int index, T object) {
        try {
            return this.unwrap(this.delegateList().set(index, this.wrap(object)));
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return null;
        }
    }

    public void addUnique(T object) {
        ++this.modCount;
        int size = this.size();
        this.delegateAdd(this.validate(size, object));
        this.didAdd(size, object);
        this.didChange();
    }

    protected void delegateAdd(T object) {
        try {
            W target = this.wrap(object);
            this.delegateList().add(target);
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    public void addUnique(int index, T object) {
        ++this.modCount;
        this.delegateAdd(index, this.validate(index, object));
        this.didAdd(index, object);
        this.didChange();
    }

    protected void delegateAdd(int index, T object) {
        try {
            this.delegateList().add(index, this.wrap(object));
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    public boolean addAllUnique(Collection<? extends T> collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        int i = this.size();
        for (T object : collection) {
            this.delegateAdd(this.validate(i, object));
            this.didAdd(i, object);
            this.didChange();
            ++i;
        }
        return true;
    }

    public boolean addAllUnique(int index, Collection<? extends T> collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        for (T object : collection) {
            this.delegateAdd(index, this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++index;
        }
        return true;
    }

    public boolean addAllUnique(Object[] objects, int start, int end) {
        int growth = end - start;
        ++this.modCount;
        if (growth == 0) {
            return false;
        }
        int index = this.size();
        int i = start;
        while (i < end) {
            Object object = objects[i];
            this.delegateAdd(this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++i;
            ++index;
        }
        return true;
    }

    public boolean addAllUnique(int index, Object[] objects, int start, int end) {
        int growth = end - start;
        ++this.modCount;
        if (growth == 0) {
            return false;
        }
        int i = start;
        while (i < end) {
            Object object = objects[i];
            this.delegateAdd(this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++i;
            ++index;
        }
        return true;
    }

    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        ListIterator i = this.listIterator();
        while (i.hasNext()) {
            if (!collection.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    public T remove(int index) {
        ++this.modCount;
        T oldObject = this.delegateRemove(index);
        this.didRemove(index, oldObject);
        this.didChange();
        return oldObject;
    }

    protected T delegateRemove(int index) {
        try {
            return this.unwrap(this.delegateList().remove(index));
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return null;
        }
    }

    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        ListIterator i = this.listIterator();
        while (i.hasNext()) {
            if (collection.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        this.doClear(this.size(), this.delegateToArray());
    }

    protected void doClear(int oldSize, Object[] oldData) {
        ++this.modCount;
        this.delegateClear();
        this.didClear(oldSize, oldData);
        this.didChange();
    }

    protected void delegateClear() {
        this.delegateList().clear();
    }

    public T move(int targetIndex, int sourceIndex) {
        T object;
        ++this.modCount;
        int size = this.size();
        if (targetIndex >= size || targetIndex < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        if (sourceIndex >= size || sourceIndex < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex != sourceIndex) {
            object = this.delegateMove(targetIndex, sourceIndex);
            this.didMove(targetIndex, object, sourceIndex);
            this.didChange();
        } else {
            object = this.delegateGet(sourceIndex);
        }
        return object;
    }

    protected T delegateMove(int targetIndex, int sourceIndex) {
        T result = this.delegateRemove(sourceIndex);
        this.delegateAdd(targetIndex, result);
        return result;
    }

    public boolean equals(Object object) {
        return this.delegateEquals(object);
    }

    protected boolean delegateEquals(Object object) {
        return this.delegateList().equals(object);
    }

    public int hashCode() {
        return this.delegateHashCode();
    }

    protected int delegateHashCode() {
        return this.delegateList().hashCode();
    }

    public String toString() {
        return this.delegateToString();
    }

    protected String delegateToString() {
        return this.delegateList().toString();
    }

    protected List<T> basicList() {
        if (this.delegateSize() == 0) {
            return ECollections.emptyEList();
        }
        return ECollections.unmodifiableEList((EList)this);
    }
}

