/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationDescriptionItemImpl;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public class ViewpointItemImpl
implements ViewpointItem,
Comparable<ViewpointItemImpl>,
ItemDecorator,
IAdaptable {
    private final Session session;
    private final Viewpoint viewpoint;
    private Resource resource;
    private boolean filterForResource;
    private final Object parent;

    public ViewpointItemImpl(Session session, Viewpoint viewpoint, Object parent) {
        this.session = session;
        this.viewpoint = viewpoint;
        this.parent = parent;
    }

    public ViewpointItemImpl(Session session, Viewpoint viewpoint, Resource resource, Object parent) {
        this(session, viewpoint, parent);
        this.resource = resource;
        this.filterForResource = true;
    }

    @Override
    public Object getWrappedObject() {
        return this.viewpoint;
    }

    @Override
    public int compareTo(ViewpointItemImpl o) {
        if (this.viewpoint.getName() != null) {
            return this.viewpoint.getName().compareTo(o.viewpoint.getName());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof ViewpointItemImpl) {
            ViewpointItemImpl objItem = (ViewpointItemImpl)obj;
            result = EqualityHelper.areEquals((EObject)this.viewpoint, (EObject)objItem.viewpoint);
        }
        return result;
    }

    public int hashCode() {
        return this.viewpoint.hashCode() + this.parent.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.viewpoint;
        }
        return null;
    }

    public boolean isFilterForResource() {
        return this.filterForResource;
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected boolean isSafeViewpoint() {
        return this.viewpoint.eResource() != null && !this.viewpoint.eIsProxy();
    }

    @Override
    public Option<Session> getSession() {
        return Options.newSome((Object)this.session);
    }

    public Collection<?> getChildren() {
        ArrayList<RepresentationDescriptionItemImpl> all = new ArrayList<RepresentationDescriptionItemImpl>();
        if (this.isSafeViewpoint()) {
            for (RepresentationDescription representationDescription : new ViewpointQuery(this.viewpoint).getAllRepresentationDescriptions()) {
                if (this.isFilterForResource()) {
                    all.add(new RepresentationDescriptionItemImpl(this.session, representationDescription, this.getResource(), this));
                    continue;
                }
                all.add(new RepresentationDescriptionItemImpl(this.session, representationDescription, this, this.viewpoint));
            }
            Collections.sort(all);
        }
        return all;
    }

    public void setFilterForResource(boolean filterForResource) {
        this.filterForResource = filterForResource;
    }

    public Object getParent() {
        return this.parent;
    }

    public String getText() {
        return this.isSafeViewpoint() ? MessageTranslator.INSTANCE.getMessage((EObject)this.viewpoint, new IdentifiedElementQuery((IdentifiedElement)this.viewpoint).getLabel()) : Messages.ViewpointItemImpl_notFoundLabel;
    }

    public Image getImage() {
        return SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor(this.viewpoint));
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint;
    }
}

