/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.EventDeliveryJob;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.JobQueue;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.AnnotationsAwareServiceContext;

public abstract class PropertyServiceContext
extends AnnotationsAwareServiceContext {
    private final PropertyDef property;

    public PropertyServiceContext(String type, ServiceContext parent, PropertyDef property, Object lock, JobQueue<EventDeliveryJob> queue) {
        super(type, parent, lock, queue);
        this.property = property;
    }

    @Override
    public <T> T find(Class<T> type) {
        Object obj = super.find(type);
        if (obj == null) {
            if (type == PropertyDef.class) {
                obj = this.property;
            } else if (type == ValueProperty.class) {
                if (this.property instanceof ValueProperty) {
                    obj = this.property;
                }
            } else if (type == ListProperty.class) {
                if (this.property instanceof ListProperty) {
                    obj = this.property;
                }
            } else if (type == ElementProperty.class) {
                if (this.property instanceof ElementProperty) {
                    obj = this.property;
                }
            } else if (type == ImpliedElementProperty.class) {
                if (this.property instanceof ImpliedElementProperty) {
                    obj = this.property;
                }
            } else if (type == TransientProperty.class && this.property instanceof TransientProperty) {
                obj = this.property;
            }
        }
        return obj;
    }

    @Override
    protected <A extends Annotation> List<A> annotations(Class<A> type) {
        return this.property.getAnnotations(type);
    }
}

