/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.preference.PHPUnitPreferenceKeys;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class PHPUnitLaunchUtils {
    private static final String RESOURCES_DIRECTORY = "resources";
    private static final String COMPOSER_JSON_FILENAME = "composer.json";
    private static final String COMPOSER_JSON_CONFIG = "config";
    private static final String COMPOSER_JSON_CONFIG_VENDORDIR = "vendor-dir";
    private static final String COMPOSER_JSON_CONFIG_VENDORDIR_DIRSEP = "/";
    private static final String DEFAULT_COMPOSER_VENDORDIR = "vendor";
    private static final String START_SCRIPT_PATH = "phpunit/phpunit";
    private static final String START_SCRIPT_NAME = "phpunit";
    private static final String OLD_START_SCRIPT_NAME = "phpunit.php";

    public static void initializeDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.php.phpunit.code_coverage", PHPUnitPreferenceKeys.getCodeCoverage());
        config.setAttribute("org.eclipse.php.phpunit.logXml", PHPUnitPreferenceKeys.getReporting());
        config.setAttribute("org.eclipse.php.phpunit.runType", "PHAR_EXECUTION_TYPE");
        config.setAttribute("org.eclipse.php.phpunit.project", "");
        config.setAttribute("org.eclipse.php.phpunit.container", "");
        config.setAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", "SCRIPT_SOURCE");
        config.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", false);
    }

    public static IPath getResourcesPath() {
        Bundle bundle = PHPUnitPlugin.getDefault().getBundle();
        try {
            String file = FileLocator.resolve((URL)bundle.getEntry(RESOURCES_DIRECTORY)).getFile();
            return new Path(file);
        }
        catch (IOException e) {
            PHPUnitPlugin.log(e);
            return null;
        }
    }

    @Nullable
    private static IPath getVendorPath(@Nullable IProject project) {
        if (project == null) {
            return null;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return null;
        }
        String vendorDir = null;
        try {
            int vendorDirLength;
            JsonElement jVendorDir;
            JsonElement jConfig;
            JsonParser parser;
            JsonElement jComposer;
            FileReader reader;
            File composerJsonFile = projectLocation.append(COMPOSER_JSON_FILENAME).toFile();
            if (composerJsonFile.exists() && composerJsonFile.isFile() && composerJsonFile.length() > 0L && (reader = new FileReader(composerJsonFile)) != null && (jComposer = (parser = new JsonParser()).parse((Reader)reader)).isJsonObject() && ((JsonObject)jComposer).has(COMPOSER_JSON_CONFIG) && (jConfig = ((JsonObject)jComposer).get(COMPOSER_JSON_CONFIG)).isJsonObject() && ((JsonObject)jConfig).has(COMPOSER_JSON_CONFIG_VENDORDIR) && (jVendorDir = ((JsonObject)jConfig).get(COMPOSER_JSON_CONFIG_VENDORDIR)).isJsonPrimitive() && ((JsonPrimitive)jVendorDir).isString() && (vendorDirLength = (vendorDir = ((JsonPrimitive)jVendorDir).getAsString()).length()) > 1 && vendorDir.endsWith(COMPOSER_JSON_CONFIG_VENDORDIR_DIRSEP)) {
                vendorDir = vendorDir.substring(0, vendorDirLength - 1);
            }
        }
        catch (Throwable e) {
            PHPUnitPlugin.log(e);
        }
        if (vendorDir == null) {
            vendorDir = DEFAULT_COMPOSER_VENDORDIR;
        }
        return projectLocation.append(vendorDir);
    }

    @Nullable
    public static String findComposerExecutionFile(@Nullable IProject project) {
        IPath vendorPath = PHPUnitLaunchUtils.getVendorPath(project);
        if (vendorPath == null) {
            return null;
        }
        IPath startScriptDirectory = vendorPath.append(START_SCRIPT_PATH);
        String[] stringArray = new String[]{START_SCRIPT_NAME, OLD_START_SCRIPT_NAME};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String startScriptName = stringArray[n2];
            IPath startScriptPath = startScriptDirectory.append(startScriptName);
            File startScriptFile = startScriptPath.toFile();
            if (startScriptFile.exists() && startScriptFile.isFile()) {
                return startScriptPath.toOSString();
            }
            ++n2;
        }
        return null;
    }

    public static IModelElement calculateContext(IEditorPart part) {
        IEditorInput input;
        if (part != null && (input = part.getEditorInput()) instanceof IFileEditorInput) {
            return PHPToolkitUtil.getSourceModule((Object)((IFileEditorInput)input).getFile());
        }
        return null;
    }

    public static IModelElement calculateContext(IStructuredSelection ss) {
        if (!ss.isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IModelElement) {
                IModelElement codeData = (IModelElement)obj;
                while (!(codeData == null || codeData instanceof IType || codeData instanceof ISourceModule || codeData instanceof IScriptFolder || codeData instanceof IScriptProject)) {
                    codeData = codeData.getParent();
                }
                return codeData;
            }
            if (obj instanceof IResource) {
                return DLTKCore.create((IFile)((IFile)obj));
            }
        }
        return null;
    }

    protected static IModelElement calculateContext(Object context) {
        IStructuredSelection sSelection = null;
        IEditorPart editor = null;
        IModelElement obj = null;
        if (context != null) {
            if (context instanceof IStructuredSelection) {
                sSelection = (IStructuredSelection)context;
            } else if (context instanceof IEditorPart) {
                editor = (IEditorPart)context;
            }
        }
        if (sSelection == null && editor == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return null;
            }
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection) {
                sSelection = (IStructuredSelection)selection;
            }
            editor = page.getActiveEditor();
        }
        if (sSelection != null) {
            obj = PHPUnitLaunchUtils.calculateContext(sSelection);
        }
        if (obj == null && editor != null) {
            obj = PHPUnitLaunchUtils.calculateContext(editor);
        }
        return obj;
    }

    public static boolean launchIsPHPUnit(ILaunch launch) {
        try {
            if (launch.getLaunchConfiguration().getType().getIdentifier().startsWith("org.eclipse.php.phpunit.")) {
                return true;
            }
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
        return false;
    }

    public static boolean isPHPUnitRunning() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.getAttribute("org.eclipse.php.phpunit.phpUnitLaunch") != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

