/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ContainmentHelper;
import org.eclipse.uml2.uml.Element;

public class ContainmentDragDropHelper
extends ContainmentHelper {
    public ContainmentDragDropHelper(TransactionalEditingDomain editDomain) {
        super(editDomain);
    }

    public Command getDropWithContainmentCommand(View hostView, View movedView) {
        if (this.isMoveToParent(hostView, movedView)) {
            return this.moveToParent(hostView, movedView);
        }
        if (this.isMoveToChild(hostView, movedView)) {
            return this.moveToChild(hostView, movedView);
        }
        if (ContainmentDragDropHelper.hasIncomingContainmentLink(movedView)) {
            return this.moveWithIncomingContainmentLink(hostView, movedView);
        }
        if (ContainmentHelper.hasOutgoingContainmentLink(movedView)) {
            return this.moveWithOutgoingContainmentLink();
        }
        return null;
    }

    private Command moveWithOutgoingContainmentLink() {
        return UnexecutableCommand.INSTANCE;
    }

    private Command moveWithIncomingContainmentLink(View hostView, View movedView) {
        CompositeCommand cmd = new CompositeCommand("Move Element");
        Element parent = (Element)hostView.getElement();
        Element child = (Element)movedView.getElement();
        cmd.add((IUndoableOperation)new MoveElementCommand(parent, child));
        cmd.add((IUndoableOperation)new AddCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)hostView), (IAdaptable)new EObjectAdapter((EObject)movedView)));
        this.deleteIncomingContainmentLinksFor(cmd, movedView);
        return new ICommandProxy((ICommand)cmd);
    }

    private Command moveToChild(View hostView, View movedView) {
        CompositeCommand cmd = new CompositeCommand("Move Element");
        Element parent = (Element)ViewUtil.resolveSemanticElement((View)((View)hostView.eContainer().eContainer()));
        Element child1 = (Element)hostView.getElement();
        Element child2 = (Element)ViewUtil.resolveSemanticElement((View)movedView);
        cmd.add((IUndoableOperation)new MoveElementCommand(parent, child1));
        cmd.add((IUndoableOperation)new MoveElementCommand(child1, child2));
        cmd.add((IUndoableOperation)new AddCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)hostView), (IAdaptable)new EObjectAdapter((EObject)movedView)));
        this.deleteOutgoingContainmentLinksFor(cmd, movedView);
        return new ICommandProxy((ICommand)cmd);
    }

    private Command moveToParent(View hostView, View movedView) {
        CompositeCommand cmd = new CompositeCommand("Move Element");
        cmd.add((IUndoableOperation)new AddCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)hostView), (IAdaptable)new EObjectAdapter((EObject)movedView)));
        this.deleteIncomingContainmentLinksFor(cmd, movedView);
        return new ICommandProxy((ICommand)cmd);
    }

    private boolean isMoveToChild(View hostView, View movedElementView) {
        return EcoreUtil.isAncestor((EObject)movedElementView.getElement(), (EObject)hostView.getElement());
    }

    private boolean isMoveToParent(View hostView, View movedElementView) {
        return hostView.getElement().equals(movedElementView.getElement().eContainer());
    }

    private class MoveElementCommand
    extends AbstractTransactionalCommand {
        private final Element myTarget;
        private final Element myMoved;

        public MoveElementCommand(Element target, Element moved) {
            super(ContainmentDragDropHelper.this.getEditingDomain(), "Move Element", Collections.emptyList());
            this.myMoved = moved;
            this.myTarget = target;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ContainmentDragDropHelper.this.move((EObject)this.myMoved, (EObject)this.myTarget);
            return CommandResult.newOKCommandResult();
        }
    }
}

