/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.internal.manager.PivotIdResolver;
import org.eclipse.ocl.pivot.internal.utilities.AbstractTechnology;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class EcoreTechnology
extends AbstractTechnology {
    public static final @NonNull EcoreTechnology INSTANCE = new EcoreTechnology();

    protected EcoreTechnology() {
    }

    @Override
    public @NonNull IdResolver createIdResolver(@NonNull EnvironmentFactoryInternal environmentFactory) {
        return new PivotIdResolver(environmentFactory);
    }

    @Override
    public RootPackageId getMetamodelId(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EPackage ePackage) {
        assert (!"http://www.eclipse.org/uml2/5.0.0/UML".equals(ePackage.getNsURI()));
        assert (!"http://www.eclipse.org/uml2/5.0.0/Types".equals(ePackage.getNsURI()));
        RootPackageId metamodel = null;
        if (ClassUtil.basicGetMetamodelAnnotation(ePackage) != null) {
            metamodel = IdManager.METAMODEL;
        } else {
            String nsURI = ePackage.getNsURI();
            String sharedNsURI = environmentFactory.getCompleteModel().getCompleteURI(nsURI);
            if (sharedNsURI != null && !sharedNsURI.equals(nsURI)) {
                metamodel = IdManager.getRootPackageId(sharedNsURI);
            }
        }
        return metamodel;
    }

    @Override
    public @NonNull PackageId getMetapackageId(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Package asPackage) {
        EClass eClass;
        EObject eTarget;
        if (asPackage instanceof PivotObjectImpl && (eTarget = ((PivotObjectImpl)((Object)asPackage)).getESObject()) != null && (eClass = eTarget.eClass()) != null) {
            EPackage ePackage = eClass.getEPackage();
            assert (!"http://www.eclipse.org/uml2/5.0.0/UML".equals(ePackage.getNsURI()));
            assert (!"http://www.eclipse.org/uml2/5.0.0/Types".equals(ePackage.getNsURI()));
        }
        return IdManager.METAMODEL;
    }

    @Override
    public boolean isStereotype(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EClass eClass) {
        for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
            EClassifier eType = eFeature.getEType();
            if (eType == null) continue;
            assert (!eType.eIsProxy()) : "Unresolved proxy: '" + EcoreUtil.getURI((EObject)eType) + "'";
            EPackage ePackage = eType.getEPackage();
            assert (!"http://www.eclipse.org/uml2/5.0.0/UML".equals(ePackage.getNsURI()));
        }
        return false;
    }
}

