/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch.data;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.DiscovererUpdate;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplay;

public class DiscovererParameterDisplayImpl
implements DiscovererParameterDisplay {
    private Object value = null;
    private final DiscovererParameter delegate;
    private final DiscovererUpdate updater;
    private final DiscovererDescription discoverer;

    public DiscovererParameterDisplayImpl(DiscovererParameter realParameterInput, DiscovererDescription discoverer, DiscovererUpdate updater) {
        this.discoverer = discoverer;
        this.updater = updater;
        this.delegate = realParameterInput;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.updater.update();
    }

    public DiscovererParameter getParameterDescription() {
        return this.delegate;
    }

    public String toString() {
        if (this.delegate != null) {
            return String.valueOf(this.delegate.getId()) + " = " + this.value;
        }
        return super.toString();
    }

    public void initialize(Object source) {
        if (IDiscoveryManager.INSTANCE.hasInitialValue(this.delegate, this.discoverer)) {
            try {
                Object initialValue = IDiscoveryManager.INSTANCE.getInitialValue(this.delegate, this.discoverer, source);
                this.setValue(initialValue);
            }
            catch (DiscoveryException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

