/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.internal.vagrant.core.Activator;
import org.eclipse.linuxtools.internal.vagrant.core.Messages;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;

public class EnvironmentsManager {
    private static EnvironmentsManager singleton = new EnvironmentsManager();
    private Environment env;

    public static EnvironmentsManager getSingleton() {
        return singleton;
    }

    private EnvironmentsManager() {
        this.getEnvironment();
    }

    private synchronized Environment getEnvironment() {
        if (this.env == null) {
            this.env = new Environment();
        }
        return this.env;
    }

    public Map<String, String> getEnvironment(File folder) {
        return this.getEnvironment().getEnvironmentForFolder(folder);
    }

    public void setEnvironment(File folder, Map<String, String> environment) {
        Environment env = this.getEnvironment();
        env.setEnvironmentForFolder(folder, environment);
        env.save();
    }

    public static String[] convertEnvironment(Map<String, String> env) {
        Map<String, String> environment = System.getenv();
        HashMap<String, String> result = new HashMap<String, String>(environment);
        if (env != null) {
            result.putAll(env);
        }
        StringBuilder path = new StringBuilder();
        String newEnvPath = path.append(environment.get("PATH")).append(File.pathSeparator).append(VagrantConnection.getUserDefinedVagrantPath()).toString();
        result.put("PATH", newEnvPath);
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = result.keySet().iterator();
        String working = null;
        while (it.hasNext()) {
            working = (String)it.next();
            ret.add(String.valueOf(working) + "=" + (String)result.get(working));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private class Environment {
        private static final String ENVIRONMENT_ATTRIBUTE = "org.eclipse.linuxtools.internal.vagrant.core.EnvironmentsManager.EnvironmentKey";
        private static final String SECURE_PREFERNCES_BASEKEY = "org.eclipse.linuxtools.vagrant.core";
        private static final String ENVIRONMENT_KEY = "environment";
        private static final boolean READ = true;
        private static final boolean WRITE = false;
        private Map<String, Map<String, String>> backing;

        public Environment() {
            this.load();
        }

        private ISecurePreferences getPreferenceNode() {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(SECURE_PREFERNCES_BASEKEY);
            return node.node(ENVIRONMENT_KEY);
        }

        private void load() {
            ISecurePreferences prefs2 = this.getPreferenceNode();
            try {
                byte[] read = prefs2.getByteArray(ENVIRONMENT_ATTRIBUTE, null);
                this.backing = new HashMap<String, Map<String, String>>();
                if (read == null) {
                    return;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(read);
                ObjectInputStream ois = new ObjectInputStream(bis);
                this.backing = (Map)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (IOException ioe) {
                Activator.getDefault().getLog().log(this.createStatus(ioe, true));
            }
            catch (ClassNotFoundException cnfe) {
                Activator.getDefault().getLog().log(this.createStatus(cnfe, true));
            }
            catch (StorageException se) {
                Activator.getDefault().getLog().log(this.createStatus(se, true));
            }
        }

        private void save() {
            if (this.backing == null) {
                this.backing = new HashMap<String, Map<String, String>>();
            }
            ISecurePreferences prefs = this.getPreferenceNode();
            try {
                byte[] toSave = null;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.backing);
                oos.close();
                bos.close();
                toSave = bos.toByteArray();
                prefs.putByteArray(ENVIRONMENT_ATTRIBUTE, toSave, true);
                prefs.flush();
            }
            catch (IOException ioe) {
                Activator.getDefault().getLog().log(this.createStatus(ioe, false));
            }
            catch (StorageException se) {
                Activator.getDefault().getLog().log(this.createStatus(se, false));
            }
        }

        private IStatus createStatus(Throwable t, boolean action) {
            if (action) {
                return new Status(4, SECURE_PREFERNCES_BASEKEY, Messages.EnvironmentsManager_error_read, t);
            }
            return new Status(4, SECURE_PREFERNCES_BASEKEY, Messages.EnvironmentsManager_error_write, t);
        }

        public void setEnvironmentForFolder(File folder, Map<String, String> env) {
            if (this.backing != null) {
                this.backing.put(folder.getAbsolutePath(), env);
            }
        }

        public Map<String, String> getEnvironmentForFolder(File folder) {
            if (this.backing != null) {
                return this.backing.get(folder.getAbsolutePath());
            }
            return null;
        }
    }
}

