/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.BuildDockerImageJob;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageBuild;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class BuildImageCommandHandler
extends AbstractHandler {
    private static final String BUILD_IMAGE_JOB_TITLE = "ImageBuild.msg";
    private static final String IMAGE_DIRECTORY_VALIDATE = "ImageDirectoryValidate.msg";

    public Object execute(ExecutionEvent event) {
        boolean buildImage;
        IDockerConnection connection;
        ImageBuild wizard = new ImageBuild();
        NonModalWizardDialog wizardDialog = new NonModalWizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        wizardDialog.create();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = null;
        IWorkbenchPart activePart = null;
        if (window != null) {
            activePage = window.getActivePage();
        }
        if (activePage != null) {
            activePart = activePage.getActivePart();
        }
        if ((connection = CommandUtils.getCurrentConnection(activePart)) == null) {
            connection = DockerConnectionManager.getInstance().getFirstConnection();
        }
        if (connection == null || !connection.isOpen()) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)WizardMessages.getString("ErrorNoActiveConnection.msg"), (String)WizardMessages.getString("ErrorNoActiveConnection.desc")));
            return null;
        }
        boolean bl = buildImage = wizardDialog.open() == 0;
        if (buildImage) {
            this.performBuildImage(wizard, connection);
        }
        return null;
    }

    private void performBuildImage(final ImageBuild wizard, final IDockerConnection connection) {
        Job buildImageJob = new Job(DVMessages.getString(BUILD_IMAGE_JOB_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                String id = wizard.getImageName();
                int lines = wizard.getNumberOfLines();
                IPath path = wizard.getDirectory();
                monitor.beginTask(DVMessages.getString(BuildImageCommandHandler.BUILD_IMAGE_JOB_TITLE), 2);
                monitor.subTask(WizardMessages.getString(BuildImageCommandHandler.IMAGE_DIRECTORY_VALIDATE));
                try {
                    Files.walkFileTree(Paths.get(path.toString(), new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (!file.toFile().canRead()) {
                                throw new IOException();
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            throw exc;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)WizardMessages.getString("ErrorInvalidDirectory.msg"), (String)WizardMessages.getFormattedString("ErrorInvalidPermissions.msg", path.toString())));
                    return Status.OK_STATUS;
                }
                monitor.worked(1);
                try {
                    monitor.subTask(DVMessages.getString(BuildImageCommandHandler.BUILD_IMAGE_JOB_TITLE));
                    BuildDockerImageJob buildImageJob = new BuildDockerImageJob(connection, path, id, null);
                    buildImageJob.schedule();
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        buildImageJob.schedule();
    }

    private static class NonModalWizardDialog
    extends WizardDialog {
        public NonModalWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | NonModalWizardDialog.getDefaultOrientation());
        }
    }
}

