/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.problems;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.Problem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.osgi.util.NLS;

public final class ProblemFactory {
    public static final IProblem ERROR_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.TooltipErrorInChildren));
    public static final IProblem WARNING_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.TooltipWarningInChildren));
    public static final IProblem MISSING_NODE = ProblemFactory.createMissingReferencedSpecTestCasesProblem();

    private ProblemFactory() {
    }

    public static IProblem createIncompleteTestDataProblem(INodePO node) {
        return new Problem(NLS.bind((String)Messages.ProblemIncompleteTestDataMarkerText, (Object)node.getName()), (IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.ProblemIncompleteTestDataTooltip), node, ProblemType.REASON_TD_INCOMPLETE);
    }

    public static IProblem createIncompleteObjectMappingProblem(IAUTMainPO aut) {
        String autName = aut.getName();
        return new Problem(NLS.bind((String)Messages.ProblemIncompleteObjectMappingMarkerText, (Object)autName), (IStatus)new Status(4, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ProblemIncompleteObjectMappingTooltip, (Object)autName)), autName, ProblemType.REASON_OM_INCOMPLETE);
    }

    public static IProblem createIncompatibleTypeProblem(IComponentNamePO cN, ProblemType type) {
        if (type.equals((Object)ProblemType.REASON_INCOMPATIBLE_MAP_TYPE)) {
            return new Problem(NLS.bind((String)Messages.ProblemIncompatibleMapTypeMarkerText, (Object)cN.getName()), (IStatus)new Status(4, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ProblemIncompatibleMapTypeMarkerText, (Object)cN.getName())), cN, type);
        }
        return new Problem(NLS.bind((String)Messages.ProblemIncompatibleUsageTypeMarkerText, (Object)cN.getName()), (IStatus)new Status(4, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ProblemIncompatibleUsageTypeMarkerText, (Object)cN.getName())), cN, type);
    }

    private static IProblem createMissingReferencedSpecTestCasesProblem() {
        return new Problem(Messages.ProblemMissingReferencedTestCaseMarkerText, (IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.ProblemMissingReferencedTestCaseTooltip), null, ProblemType.REASON_MISSING_SPEC_TC);
    }

    public static IProblem createProblem(IStatus status) {
        return new Problem(null, status, null, ProblemType.NO_QUICKFIX);
    }

    public static IProblem createProblemWithMarker(IStatus status, String markerMessage, Object data, ProblemType probType) {
        Problem problem = new Problem(markerMessage, status, data, probType);
        if (data instanceof INodePO) {
            ((INodePO)data).addProblem(problem);
        }
        return problem;
    }

    public static IProblem getWorstProblem(Set<IProblem> problems) {
        IProblem worstProblem = null;
        for (IProblem problem : problems) {
            if (worstProblem != null && worstProblem.getStatus().getSeverity() >= problem.getStatus().getSeverity()) continue;
            worstProblem = problem;
        }
        return worstProblem;
    }

    public static IProblem getWorstNoOMIncompleteProblem(Set<IProblem> problems) {
        IProblem worstProblem = null;
        for (IProblem problem : problems) {
            if (problem.getProblemType().equals((Object)ProblemType.REASON_OM_INCOMPLETE) || worstProblem != null && worstProblem.getStatus().getSeverity() >= problem.getStatus().getSeverity()) continue;
            worstProblem = problem;
        }
        return worstProblem;
    }

    public static Set<IProblem> getWorstProblems(Set<IProblem> problems) {
        IProblem worstProblem = ProblemFactory.getWorstProblem(problems);
        HashSet<IProblem> worstProblems = new HashSet<IProblem>();
        if (worstProblem != null) {
            for (IProblem problem : problems) {
                if (worstProblem.getStatus().getSeverity() != problem.getStatus().getSeverity()) continue;
                worstProblems.add(problem);
            }
        }
        return worstProblems;
    }

    public static boolean hasProblem(INodePO node) {
        return node.getProblems().size() > 0;
    }

    public static boolean hasNoOMIProblem(INodePO node) {
        for (IProblem problem : node.getProblems()) {
            if (problem.getProblemType().equals((Object)ProblemType.REASON_OM_INCOMPLETE)) continue;
            return true;
        }
        return false;
    }
}

