/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompCheck;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public final class CompletenessGuard {
    private CompletenessGuard() {
    }

    public static void checkAll(INodePO root, IProgressMonitor monitor) {
        TreeTraverser traverser = new TreeTraverser(root);
        traverser.setTraverseSpecPart(true);
        traverser.setMonitor(monitor);
        traverser.setTraverseIntoExecs(false);
        traverser.setTraverseSpecPart(true);
        traverser.addOperation(new CheckTestDataCompleteness());
        traverser.addOperation(new CheckMissingTestCaseReferences());
        traverser.addOperation(new InactiveNodesOperation());
        traverser.addOperation(new CheckEmptyConditions());
        traverser.traverse(true);
        List<ITestSuitePO> tsList = null;
        if (root.equals(GeneralStorage.getInstance().getProject())) {
            tsList = TestSuiteBP.getListOfTestSuites();
        } else if (root instanceof ITestSuitePO) {
            tsList = new ArrayList<ITestSuitePO>();
            tsList.add((ITestSuitePO)root);
        }
        if (tsList != null && !tsList.isEmpty()) {
            CompCheck check = new CompCheck(tsList);
            check.traverse();
            check.addProblems();
        }
    }

    public static void checkTestData(INodePO root) {
        new TreeTraverser(root, new CheckTestDataCompleteness()).traverse(true);
    }

    private static void setNodeProblem(INodePO node, IProblem problem, boolean deleteOrAdd) {
        if (deleteOrAdd) {
            node.removeProblem(problem);
        } else {
            node.addProblem(problem);
        }
    }

    private static void setCompletenessMissingTestCase(INodePO node, boolean completeTCFlag) {
        CompletenessGuard.setNodeProblem(node, ProblemFactory.MISSING_NODE, completeTCFlag);
    }

    public static void setCompletenessTestData(INodePO node, boolean flag) {
        CompletenessGuard.setNodeProblem(node, ProblemFactory.createIncompleteTestDataProblem(node), flag);
    }

    public static void checkLocalTestData(INodePO node) {
        IExecTestCasePO execTc;
        INodePO possibleDataSourceNode = node;
        if (node instanceof IExecTestCasePO && (execTc = (IExecTestCasePO)node).getHasReferencedTD()) {
            possibleDataSourceNode = execTc.getSpecTestCase();
        }
        if (possibleDataSourceNode instanceof IParamNodePO) {
            IParamNodePO dataSourceNode = (IParamNodePO)possibleDataSourceNode;
            INodePO nodeToModify = null;
            if (!(node instanceof ISpecTestCasePO)) {
                nodeToModify = node;
            }
            if (nodeToModify != null) {
                CompletenessGuard.setCompletenessTestData(nodeToModify, dataSourceNode.isTestDataComplete());
            }
        }
    }

    public static void checkEmptyContainer(INodePO node) {
        List<INodePO> list = node.getUnmodifiableNodeList();
        for (INodePO child : list) {
            if (!(child instanceof ICondStructPO) && !(child instanceof IIteratePO)) continue;
            boolean ok = false;
            IAbstractContainerPO branch = null;
            branch = child instanceof ICondStructPO ? ((ICondStructPO)child).getCondition() : ((IIteratePO)child).getDoBranch();
            Iterator<INodePO> it = branch.getNodeListIterator();
            while (it.hasNext()) {
                INodePO branchChild = it.next();
                if (!branchChild.isActive() || branchChild instanceof ICommentPO) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            String message = Messages.ProblemIncompleteBranch;
            child.addProblem(ProblemFactory.createProblemWithMarker((IStatus)new Status(4, "org.eclipse.jubula.client.core", message), message, child, ProblemType.REASON_IF_WITHOUT_TEST));
        }
    }

    private static class CheckEmptyConditions
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckEmptyConditions() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (alreadyVisited) {
                return false;
            }
            if (node instanceof ITestSuitePO || node instanceof ISpecTestCasePO) {
                CompletenessGuard.checkEmptyContainer(node);
                return false;
            }
            return true;
        }
    }

    private static class CheckMissingTestCaseReferences
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckMissingTestCaseReferences() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                boolean isMissingSpecTc = execTc.getSpecTestCase() == null;
                CompletenessGuard.setCompletenessMissingTestCase(execTc, !isMissingSpecTc);
            }
            return !alreadyVisited;
        }
    }

    private static class CheckTestDataCompleteness
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckTestDataCompleteness() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (alreadyVisited) {
                return false;
            }
            CompletenessGuard.checkLocalTestData(node);
            return true;
        }
    }

    private static class InactiveNodesOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private InactiveNodesOperation() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (!node.isActive()) {
                HashSet<IProblem> problemsToRemove = new HashSet<IProblem>(node.getProblems());
                for (IProblem problem : problemsToRemove) {
                    node.removeProblem(problem);
                }
            }
            return !alreadyVisited;
        }
    }
}

