/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.impl;

import java.net.ConnectException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.Remote;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.Synchronizer;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.internal.impl.AUTImpl;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.GetRegisteredAutListMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerMessage;
import org.eclipse.jubula.communication.internal.message.StopAUTServerMessage;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTAgentImpl
implements AUTAgent {
    private static Logger log = LoggerFactory.getLogger(AUTAgentImpl.class);
    private String m_hostname;
    private String m_port;
    private AutAgentConnection m_agent;

    public AUTAgentImpl(String hostname, int iPort) {
        Validate.notEmpty((String)hostname, (String)"The hostname must not be empty.");
        String port = String.valueOf(iPort);
        String portNumberMessage = NetUtil.isPortNumberValid((String)port);
        Validate.isTrue((portNumberMessage == null ? 1 : 0) != 0, (String)portNumberMessage);
        this.m_hostname = hostname;
        this.m_port = port;
    }

    @Override
    public void connect() throws org.eclipse.jubula.client.exceptions.CommunicationException {
        block6: {
            if (!this.isConnected()) {
                try {
                    AutAgentConnection.createInstance(this.m_hostname, this.m_port);
                    this.m_agent = AutAgentConnection.getInstance();
                    this.m_agent.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new ErrorListener(Thread.currentThread()));
                    this.m_agent.run();
                    if (!this.isConnected()) {
                        AUTAgentImpl.printlnConsoleError("Could not connect to AUT-Agent: " + this.m_hostname + ":" + this.m_port);
                        throw new org.eclipse.jubula.client.exceptions.CommunicationException(new ConnectException("Could not connect to AUT-Agent: " + this.m_hostname + ":" + this.m_port));
                    }
                    break block6;
                }
                catch (ConnectionException e) {
                    AUTAgentImpl.printlnConsoleError("The connection to the AUTServer could not initialized.");
                    throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
                }
                catch (BaseConnection.AlreadyConnectedException e) {
                    AUTAgentImpl.printlnConsoleError("This connection is already connected");
                    throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
                }
                catch (JBVersionException e) {
                    AUTAgentImpl.printlnConsoleError("There is a version conflict between the client and the AUT agent.");
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
                }
            }
            throw new IllegalStateException("AUT-Agent connection is already made");
        }
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            throw new IllegalStateException("AUT-Agent connection is already disconnected");
        }
        this.m_agent.close();
    }

    @Override
    public boolean isConnected() {
        return this.m_agent != null ? this.m_agent.isConnected() : false;
    }

    @Override
    public AUTIdentifier startAUT(@NonNull AUTConfiguration configuration) throws org.eclipse.jubula.client.exceptions.CommunicationException {
        Validate.notNull((Object)configuration, (String)"The configuration must not be null.");
        AUTAgentImpl.checkConnected(this);
        HashMap<String, String> autConfigMap = new HashMap<String, String>(configuration.getLaunchInformation());
        Communicator communicator = this.m_agent.getCommunicator();
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autAgentPort", String.valueOf(communicator.getPort()));
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autAgentHost", communicator.getHostName());
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autName", (String)autConfigMap.get("AUT_ID"));
        String toolkitID = (String)autConfigMap.get("toolkitID");
        StartAUTServerMessage startAUTMessage = new StartAUTServerMessage(autConfigMap, toolkitID);
        try {
            this.m_agent.send((Message)startAUTMessage);
            Object genericStartResponse = Synchronizer.instance().exchange(null);
            if (genericStartResponse instanceof Integer) {
                int startResponse = genericStartResponse;
                return this.handleResponse(startResponse);
            }
            log.error("Unexpected start response code received: " + String.valueOf(genericStartResponse));
        }
        catch (BaseConnection.NotConnectedException e) {
            AUTAgentImpl.printlnConsoleError(e.getLocalizedMessage());
            throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            AUTAgentImpl.printlnConsoleError(e.getLocalizedMessage());
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        catch (InterruptedException e) {
            AUTAgentImpl.printlnConsoleError(e.getLocalizedMessage());
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutIdentifier handleResponse(int startResponse) throws org.eclipse.jubula.client.exceptions.CommunicationException {
        if (startResponse == 0) {
            try {
                Object autIdentifier = Synchronizer.instance().exchange(null);
                if (autIdentifier instanceof AutIdentifier) {
                    return autIdentifier;
                }
                log.error("Unexpected AUT identifier received: " + String.valueOf(autIdentifier));
                if (!(autIdentifier instanceof Integer)) return null;
                int autStartResponseCode = autIdentifier;
                this.handleErrorResponse(autStartResponseCode);
                return null;
            }
            catch (InterruptedException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
            }
        } else {
            this.handleErrorResponse(startResponse);
        }
        return null;
    }

    private void handleErrorResponse(int startResponse) {
        switch (startResponse) {
            case 3: {
                AUTAgentImpl.printlnConsoleError("No Java found");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                AUTAgentImpl.printlnConsoleError("AUTServer could not start.");
                break;
            }
            case 11: {
                AUTAgentImpl.printlnConsoleError("AUTServer could not start,  because parameters are invalid.");
                break;
            }
            case 7: {
                AUTAgentImpl.printlnConsoleError("AUTServer could not start, because main is not distinct in jar.");
                break;
            }
            case 6: {
                AUTAgentImpl.printlnConsoleError("AUTServer could not start, because no main class found in the jar.");
                break;
            }
            case 8: 
            case 9: {
                AUTAgentImpl.printlnConsoleError("AUTServer could not start,  because the given jar is invalid.");
                break;
            }
            case 12: {
                AUTAgentImpl.printlnConsoleError("AUT server could not be instantiated");
                break;
            }
            case 13: {
                AUTAgentImpl.printlnConsoleError("The .NET runtime is not properly installed");
                break;
            }
            case 14: {
                AUTAgentImpl.printlnConsoleError("the JDK used by the AUT is probably older than 1.5, or javaagent is unknown ");
                break;
            }
        }
    }

    @Override
    public void stopAUT(@NonNull AUTIdentifier aut) throws org.eclipse.jubula.client.exceptions.CommunicationException {
        Validate.notNull((Object)aut, (String)"The AUT-Identifier must not be null.");
        AUTAgentImpl.checkConnected(this);
        try {
            this.m_agent.send((Message)new StopAUTServerMessage((AutIdentifier)aut));
        }
        catch (BaseConnection.NotConnectedException e) {
            throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
    }

    @Override
    @NonNull
    public List<AUTIdentifier> getAllRegisteredAUTIdentifier() throws org.eclipse.jubula.client.exceptions.CommunicationException {
        AUTAgentImpl.checkConnected(this);
        try {
            List<AUTIdentifier> unmodifiableList;
            this.m_agent.send((Message)new GetRegisteredAutListMessage());
            Object arrayOfAutIdentifier = Synchronizer.instance().exchange(null);
            if (arrayOfAutIdentifier instanceof AutIdentifier[] && (unmodifiableList = Collections.unmodifiableList(Arrays.asList(arrayOfAutIdentifier))) != null) {
                return unmodifiableList;
            }
            log.error("Unexpected AUT identifiers received: " + String.valueOf(arrayOfAutIdentifier));
        }
        catch (BaseConnection.NotConnectedException e) {
            throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        return new ArrayList<AUTIdentifier>(0);
    }

    @Override
    @NonNull
    public AUT getAUT(@NonNull AUTIdentifier autID, @NonNull ToolkitInfo information) throws org.eclipse.jubula.client.exceptions.CommunicationException {
        Validate.notNull((Object)autID, (String)"The AUT-Identifier must not be null.");
        Validate.notNull((Object)information, (String)"The toolkit information must not be null.");
        AUTAgentImpl.checkConnected(this);
        return new AUTImpl((AutIdentifier)autID, information);
    }

    static void checkConnected(Remote side) {
        if (!side.isConnected()) {
            throw new IllegalStateException("There is currently no connection established to the remote side - call connect() first!");
        }
    }

    public static void printlnConsoleError(String text) {
        System.err.println("An error ocurred: \n\t" + text);
    }

    public static class ErrorListener
    implements ICommunicationErrorListener {
        private static Logger logger = LoggerFactory.getLogger(ErrorListener.class);
        private Thread m_thread;

        public ErrorListener(Thread thread) {
            this.m_thread = thread;
        }

        public void connectionGained(InetAddress inetAddress, int port) {
        }

        public void shutDown() {
            logger.debug("shutdown() called. Interrupting thread: " + this.m_thread.getName());
            this.m_thread.interrupt();
        }

        public void sendFailed(Message message) {
            logger.error("sendFailed() called. Interrupting thread: " + this.m_thread.getName());
            this.m_thread.interrupt();
        }

        public void acceptingFailed(int port) {
            logger.error("acceptingFailed() called. Interrupting thread: " + this.m_thread.getName());
            this.m_thread.interrupt();
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            logger.error("connectingFailed() called. Interrupting thread: " + this.m_thread.getName());
            this.m_thread.interrupt();
        }
    }
}

