/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParameterKind implements Enumerator
{
    BY_VALUE(0, "byValue", "byValue"),
    BY_NAME(1, "byName", "byName"),
    BY_REFERENCE(2, "byReference", "byReference"),
    VARIADIC(3, "variadic", "variadic"),
    RETURN(4, "return", "return"),
    THROWS(5, "throws", "throws"),
    EXCEPTION(6, "exception", "exception"),
    CATCHALL(7, "catchall", "catchall"),
    UNKNOWN(8, "unknown", "unknown");

    public static final int BY_VALUE_VALUE = 0;
    public static final int BY_NAME_VALUE = 1;
    public static final int BY_REFERENCE_VALUE = 2;
    public static final int VARIADIC_VALUE = 3;
    public static final int RETURN_VALUE = 4;
    public static final int THROWS_VALUE = 5;
    public static final int EXCEPTION_VALUE = 6;
    public static final int CATCHALL_VALUE = 7;
    public static final int UNKNOWN_VALUE = 8;
    private static final ParameterKind[] VALUES_ARRAY;
    public static final List<ParameterKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterKind[]{BY_VALUE, BY_NAME, BY_REFERENCE, VARIADIC, RETURN, THROWS, EXCEPTION, CATCHALL, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind get(int value) {
        switch (value) {
            case 0: {
                return BY_VALUE;
            }
            case 1: {
                return BY_NAME;
            }
            case 2: {
                return BY_REFERENCE;
            }
            case 3: {
                return VARIADIC;
            }
            case 4: {
                return RETURN;
            }
            case 5: {
                return THROWS;
            }
            case 6: {
                return EXCEPTION;
            }
            case 7: {
                return CATCHALL;
            }
            case 8: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ParameterKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

