/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.Messages;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.OperationCanceledException;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.Util;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BigListItem
implements ITreeElement {
    public static final int SPLIT_THRESHOLD = 1000;
    private static final int SHOW_PROGRESS_DIALOG_THRESHOLD = 5000;
    private final List<Object> elements;
    private final ITreeElement treeParent;
    private final EObject modelParent;
    private final int startIndex;
    private final int endIndex;

    public BigListItem(List<Object> sublist, int startIndex, int endIndex, ITreeElement treeParent, EObject modelParent) {
        this.elements = sublist;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.treeParent = treeParent;
        this.modelParent = modelParent;
    }

    public List<Object> getChildren() {
        return Collections.unmodifiableList(this.elements);
    }

    public Object getParent() {
        return this.treeParent;
    }

    public EObject getModelParent() {
        return this.modelParent;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getRangeIcon();
    }

    @Override
    public String getText() {
        int nElements = this.elements.size();
        int maxDigits = (int)Math.ceil(Math.log10(nElements));
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        String strStartIndex = "" + this.startIndex;
        String strEndIndex = "" + (this.endIndex - 1);
        BigListItem.zeroes(maxDigits - strStartIndex.length(), buffer);
        buffer.append(strStartIndex);
        buffer.append("..");
        BigListItem.zeroes(maxDigits - strEndIndex.length(), buffer);
        buffer.append(strEndIndex);
        buffer.append("]");
        return buffer.toString();
    }

    private static void zeroes(int count, StringBuilder buffer) {
        int i = 0;
        while (i < count) {
            buffer.append('0');
            ++i;
        }
    }

    public static List<?> splitElements(ITreeElement treeParent, EObject modelParent, List<? extends Object> elements, AppearanceConfiguration appearanceConfiguration, boolean ordered) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (elements.size() <= 1000) {
            int order = 0;
            for (Object object : elements) {
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    ModelElementItem modelElementItem = appearanceConfiguration.getItemsFactory().createModelElementItem(eObject, treeParent, appearanceConfiguration);
                    if (ordered) {
                        modelElementItem.setOrder(order++);
                    }
                    items.add(modelElementItem);
                    continue;
                }
                items.add(object);
            }
            if (appearanceConfiguration.isSortInstances()) {
                BigListItem.sortElements(items);
            }
            return items;
        }
        int order = 0;
        for (Object object : elements) {
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                ModelElementItem modelElementItem = appearanceConfiguration.getItemsFactory().createModelElementItem(eObject, null, appearanceConfiguration);
                if (ordered) {
                    modelElementItem.setOrder(order++);
                }
                items.add(modelElementItem);
                continue;
            }
            items.add(object);
        }
        if (appearanceConfiguration.isSortInstances()) {
            BigListItem.sortElements(items);
        }
        ArrayList<BigListItem> arrayList = new ArrayList<BigListItem>();
        int start = 0;
        while (start < elements.size()) {
            int end = start + 1000;
            if (end > elements.size()) {
                end = elements.size();
            }
            List<Object> sublist = items.subList(start, end);
            BigListItem bigListItem = new BigListItem(sublist, start, end, treeParent, modelParent);
            for (Object element : sublist) {
                if (!(element instanceof ModelElementItem)) continue;
                ModelElementItem modelElementItem = (ModelElementItem)element;
                modelElementItem.setTreeParent(bigListItem);
            }
            arrayList.add(bigListItem);
            start += 1000;
        }
        return arrayList;
    }

    static void sortElements(final List<Object> items) {
        final IRunnableWithProgress sortOperation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                final boolean runningInUIThread = Display.getDefault().getThread() == Thread.currentThread();
                monitor.beginTask(Messages.BigListItem_sortingInstances, -1);
                Collections.sort(items, new Comparator<Object>(){
                    private int count = 0;
                    private static final int CANCELED_POLLING_INTERVAL = 1000;

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (this.count++ % 1000 == 0) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (runningInUIThread) {
                                Display.getDefault().readAndDispatch();
                            }
                        }
                        if (!(o1 instanceof ModelElementItem)) {
                            return -1;
                        }
                        if (!(o2 instanceof ModelElementItem)) {
                            return 1;
                        }
                        ModelElementItem e1 = (ModelElementItem)o1;
                        ModelElementItem e2 = (ModelElementItem)o2;
                        int metaclassComparison = e1.getEObject().eClass().getName().compareToIgnoreCase(e2.getEObject().eClass().getName());
                        if (metaclassComparison != 0) {
                            return metaclassComparison;
                        }
                        String label1 = e1.getName();
                        String label2 = e2.getName();
                        return label1.compareToIgnoreCase(label2);
                    }
                });
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        final Shell shell = window != null ? window.getShell() : null;
        try {
            if (items.size() < 5000) {
                sortOperation.run((IProgressMonitor)new NullProgressMonitor());
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                            progressMonitorDialog.setOpenOnRun(items.size() > 5000);
                            progressMonitorDialog.run(false, true, sortOperation);
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getCause() instanceof OperationCanceledException)) {
                                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                            }
                        }
                        catch (InterruptedException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                    }
                });
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            MoDiscoLogger.logInfo((String)Messages.BigListItem_sortingCanceled, (Plugin)Activator.getDefault());
        }
        catch (InvocationTargetException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public boolean hasChildren() {
        return this.elements.size() > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigListItem) {
            BigListItem other = (BigListItem)obj;
            return Util.safeEquals(this.modelParent, other.modelParent) && this.startIndex == other.startIndex;
        }
        return false;
    }

    public int hashCode() {
        int ownHashCode = this.startIndex * 7 + 13;
        if (this.modelParent != null) {
            return this.modelParent.hashCode() * 47 + ownHashCode;
        }
        return ownHashCode;
    }

    public String toString() {
        return String.valueOf(BigListItem.class.getSimpleName()) + "(" + this.getText() + ")";
    }
}

