/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentUtil {
    public static String computeUserAgent() {
        Bundle mpcCoreBundle = FrameworkUtil.getBundle(HttpClientTransport.class);
        BundleContext context = mpcCoreBundle.getBundleContext();
        String version = UserAgentUtil.getAgentVersion(mpcCoreBundle);
        String java = UserAgentUtil.getAgentJava(context);
        String os = UserAgentUtil.getAgentOS(context);
        String language = UserAgentUtil.getProperty(context, "osgi.nl", "unknownLanguage");
        String agentDetail = UserAgentUtil.getAgentDetail(context);
        String userAgent = MessageFormat.format("mpc/{0} (Java {1}; {2}; {3}) {4}", version, java, os, language, agentDetail);
        return userAgent;
    }

    private static String getAgentVersion(Bundle bundle) {
        Version mpcCoreVersion = bundle.getVersion();
        String version = MessageFormat.format("{0}.{1}.{2}", mpcCoreVersion.getMajor(), mpcCoreVersion.getMinor(), mpcCoreVersion.getMicro());
        return version;
    }

    private static String getAgentJava(BundleContext context) {
        String javaSpec = UserAgentUtil.getProperty(context, "java.runtime.version", "unknownJava");
        String javaVendor = UserAgentUtil.getProperty(context, "java.vendor", "unknownJavaVendor");
        String java = MessageFormat.format("{0} {1}", javaSpec, javaVendor);
        return java;
    }

    private static String getAgentOS(BundleContext context) {
        String osName = UserAgentUtil.getProperty(context, "org.osgi.framework.os.name", "unknownOS");
        String osVersion = UserAgentUtil.getProperty(context, "org.osgi.framework.os.version", "unknownOSVersion");
        String osArch = UserAgentUtil.getProperty(context, "org.osgi.framework.processor", "unknownArch");
        String os = MessageFormat.format("{0} {1} {2}", osName, osVersion, osArch);
        return os;
    }

    private static String getAgentDetail(BundleContext context) {
        String agentDetail = UserAgentUtil.getProperty(context, HttpClientTransport.USER_AGENT_PROPERTY, null);
        if (agentDetail == null) {
            String productId = UserAgentUtil.getProperty(context, "eclipse.product", null);
            String productVersion = UserAgentUtil.getProperty(context, "eclipse.buildId", null);
            String appId = UserAgentUtil.getProperty(context, "eclipse.application", null);
            if (productId == null || productVersion == null) {
                Map<String, String> defaultRequestMetaParameters = ServiceLocator.computeDefaultRequestMetaParameters();
                productId = UserAgentUtil.getProperty(defaultRequestMetaParameters, (Object)"product", "unknownProduct");
                productVersion = UserAgentUtil.getProperty(defaultRequestMetaParameters, (Object)"product.version", "unknownBuildId");
            }
            if (appId == null) {
                IProduct product = Platform.getProduct();
                if (product != null) {
                    appId = product.getApplication();
                }
                if (appId == null) {
                    appId = "unknownApp";
                }
            }
            agentDetail = MessageFormat.format("{0}/{1} ({2})", productId, productVersion, appId);
        }
        return agentDetail;
    }

    private static String getProperty(BundleContext context, String key, String defaultValue) {
        String value = context.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String getProperty(Map<?, String> properties, Object key, String defaultValue) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

