/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;

public class ContainerLaunchConfigurationDelegate
extends GdbLaunchDelegate
implements ILaunchConfigurationDelegate {
    private ContainerLauncher launcher = new ContainerLauncher();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath commandPath = this.getCommandPath(configuration);
        if (commandPath != null) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("org.eclipse.cdt.container-launch", "");
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            labels.put("org.eclipse.cdt.project-name", projectName);
            if (mode.equals("run")) {
                ArrayList<String> additionalDirs;
                Path workingPath;
                String commandDir = commandPath.removeLastSegments(1).toPortableString();
                String commandString = commandPath.toPortableString();
                if (commandPath.getDevice() != null) {
                    commandDir = "/" + commandDir.replace(':', '/');
                    commandString = "/" + commandString.replace(':', '/');
                }
                StringBuilder b = new StringBuilder();
                b.append(commandString);
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                if (workingDir != null && (workingPath = new Path(workingDir)).getDevice() != null) {
                    workingDir = "/" + workingPath.toPortableString().replace(':', '/');
                }
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                if ((additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null)) != null) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    for (String additionalDir : additionalDirs) {
                        Path path = new Path(additionalDir);
                        String dir = path.toPortableString();
                        if (path.getDevice() != null) {
                            dir = "/" + dir.replace(':', '/');
                        }
                        dirs.add(dir);
                    }
                    additionalDirs = dirs;
                }
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                boolean privilegedMode = configuration.getAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, false);
                this.launcher.launch("org.eclipse.cdt.docker.launcher", null, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, null, keepContainer, supportStdin, privilegedMode, labels);
            } else if (mode.equals("debug")) {
                ArrayList<String> additionalDirs;
                Path workingPath;
                String gdbserverPortNumber = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
                List<String> ports = Arrays.asList(String.valueOf(gdbserverPortNumber) + "/tcp");
                String gdbserverCommand = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                String commandString = commandPath.toPortableString();
                String commandDir = commandPath.removeLastSegments(1).toPortableString();
                if (commandPath.getDevice() != null) {
                    commandDir = "/" + commandDir.replace(':', '/');
                    commandString = "/" + commandString.replace(':', '/');
                }
                String commandArguments = ":" + gdbserverPortNumber + " " + this.spaceEscapify(commandString);
                StringBuilder b = new StringBuilder();
                b.append(gdbserverCommand).append(' ').append(commandArguments);
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                if (workingDir != null && (workingPath = new Path(workingDir)).getDevice() != null) {
                    workingDir = "/" + workingPath.toPortableString().replace(':', '/');
                }
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                if ((additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null)) != null) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    for (String additionalDir : additionalDirs) {
                        Path path = new Path(additionalDir);
                        String dir = path.toPortableString();
                        if (path.getDevice() != null) {
                            dir = "/" + dir.replace(':', '/');
                        }
                        dirs.add(dir);
                    }
                    additionalDirs = dirs;
                }
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean isLocalConnection = true;
                try {
                    Pattern ipaddrPattern = Pattern.compile("[a-z]*://([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)[:]*[0-9]*");
                    Matcher m = ipaddrPattern.matcher(connectionUri);
                    if (m.matches()) {
                        String ipaddr = m.group(1);
                        InetAddress addr = InetAddress.getByName(ipaddr);
                        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                            isLocalConnection = true;
                        } else {
                            try {
                                isLocalConnection = NetworkInterface.getByInetAddress(addr) != null;
                            }
                            catch (SocketException e) {
                                isLocalConnection = false;
                            }
                        }
                    }
                }
                catch (UnknownHostException e) {
                    Activator.log((Throwable)e);
                }
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                boolean privilegedMode = configuration.getAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, false);
                StartGdbServerJob job = new StartGdbServerJob(Messages.Gdbserver_start);
                job.schedule();
                this.launcher.launch("org.eclipse.cdt.docker.launcher", (IContainerLaunchListener)job, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keepContainer, supportStdin, privilegedMode, labels, "seccomp:unconfined");
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (job.getResult() == Status.OK_STATUS && job.getIpAddress() != null) {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
                    wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
                    if (job.getPorts() != null && isLocalConnection) {
                        Map<String, List<IDockerPortBinding>> hostPorts = job.getPorts();
                        List<IDockerPortBinding> bindingList = hostPorts.get(String.valueOf(gdbserverPortNumber) + "/tcp");
                        if (bindingList != null && !bindingList.isEmpty()) {
                            IDockerPortBinding firstBinding = bindingList.get(0);
                            wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", "localhost");
                            wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", firstBinding.hostPort());
                        }
                    } else {
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", job.getIpAddress());
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
                    }
                    wc.doSave();
                    try {
                        try {
                            super.launch(configuration, mode, launch, monitor);
                        }
                        catch (CoreException ex) {
                            this.launcher.cleanup(connectionUri, job.getContainerInfo());
                            throw ex;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    private String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        if (args != null && args.length() > 0) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    private IPath getCommandPath(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName.length() > 0) {
            IProject project = CCorePlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            String name = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            if (name.length() == 0) {
                return null;
            }
            Path exePath = new Path(name);
            if (!exePath.isAbsolute()) {
                IPath location = project.getLocation();
                if (location == null) {
                    return null;
                }
                exePath = location.append(name);
                if (!exePath.toFile().exists()) {
                    IFile projFile = null;
                    try {
                        projFile = project.getFile(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (projFile == null || !projFile.exists()) {
                        return null;
                    }
                    exePath = projFile.getLocation();
                }
            }
            if (!exePath.toFile().exists()) {
                return null;
            }
            if (!exePath.toFile().isFile()) {
                return null;
            }
            return exePath;
        }
        return null;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.docker.launcher";
    }

    private class StartGdbServerJob
    extends Job
    implements IContainerLaunchListener {
        private boolean started;
        private boolean done;
        private IDockerContainerInfo info;

        public StartGdbServerJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            while (!this.done) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.started && this.getIpAddress() != null) {
                    this.done = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void newOutput(String output) {
            if (output.contains(Messages.Gdbserver_up) || output.contains("gdbserver:")) {
                this.started = true;
            }
        }

        public String getIpAddress() {
            if (this.info != null) {
                IDockerNetworkSettings networkSettings = this.info.networkSettings();
                return networkSettings.ipAddress();
            }
            return null;
        }

        public Map<String, List<IDockerPortBinding>> getPorts() {
            if (this.info != null) {
                IDockerNetworkSettings networkSettings = this.info.networkSettings();
                return networkSettings.ports();
            }
            return null;
        }

        public IDockerContainerInfo getContainerInfo() {
            return this.info;
        }

        public void done() {
            this.done = true;
        }

        public void containerInfo(IDockerContainerInfo info) {
            this.info = info;
        }
    }
}

