/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ProcessType;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TDeployment;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ddFactory;
import org.eclipse.bpel.model.Process;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;

public class DeployUtils {
    public static final String URL_PREFIX_FILE = "file";
    public static final String URL_PREFIX_PLATFORM = "platform";
    public static final String URL_PREFIX_RESOURCE = "resource";
    public static final String NONE_STRING = "-- none -- ";
    public static final String BPEL_CONTENT_TYPE = "org.eclipse.bpel.contenttype";

    public static ProcessType findProcessTypeInDD(Process process, TDeployment dd) {
        for (ProcessType pt : dd.getProcess()) {
            if (!pt.getName().getLocalPart().equals(process.getName()) || !pt.getName().getNamespaceURI().equals(process.getTargetNamespace())) continue;
            return pt;
        }
        return null;
    }

    public static ProcessType createProcessStub(Process process) {
        ProcessType pt = ddFactory.eINSTANCE.createProcessType();
        QName processQName = new QName(process.getTargetNamespace(), process.getName());
        pt.setName(processQName);
        return pt;
    }

    public static QName getQNameFromSerialzedForm(String qNameAsString) {
        int pos = qNameAsString.lastIndexOf("}");
        String ns = qNameAsString.substring(1, pos);
        String name = qNameAsString.substring(pos + 1, qNameAsString.length());
        QName qName = new QName(ns, name);
        return qName;
    }

    public static Port findPortByName(String name, IProject bpelProject, ResourceSet resourceSet) {
        ArrayList<Service> serviceList = new ArrayList<Service>();
        ArrayList portList = new ArrayList();
        List<Definition> wsdlDefs = DeployUtils.loadAllWSDLFromProject(bpelProject, resourceSet);
        for (Definition current : wsdlDefs) {
            Map services = current.getServices();
            if (services.isEmpty()) continue;
            Collection values = services.values();
            for (Service name2 : values) {
                serviceList.add(name2);
            }
        }
        for (Service currentService : serviceList) {
            Map portMap = currentService.getPorts();
            Collection ports = portMap.values();
            portList.addAll(ports);
        }
        for (Port currentPort : portList) {
            if (!currentPort.getName().equals(name)) continue;
            return currentPort;
        }
        return null;
    }

    public static Process loadBPEL(IFile bpelFile, ResourceSet resourceSet) {
        IPath fullProcessPath = bpelFile.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)fullProcessPath.toString(), (boolean)false);
        Resource bpelResource = resourceSet.getResource(uri, true);
        EcorePackage instance = EcorePackage.eINSTANCE;
        instance.eAdapters();
        try {
            if (bpelResource.isLoaded()) {
                bpelResource.unload();
            }
            bpelResource.load(Collections.EMPTY_MAP);
            EList contents = bpelResource.getContents();
            if (!contents.isEmpty()) {
                return (Process)contents.get(0);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Definition loadWSDL(IFile wsdlFile, ResourceSet resourceSet) {
        IPath fullProcessPath = wsdlFile.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)fullProcessPath.toString(), (boolean)false);
        Resource wsdlResource = resourceSet.getResource(uri, true);
        EcorePackage instance = EcorePackage.eINSTANCE;
        instance.eAdapters();
        try {
            wsdlResource.load(Collections.EMPTY_MAP);
            EList contents = wsdlResource.getContents();
            if (!contents.isEmpty()) {
                return (Definition)contents.get(0);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static List<Definition> loadAllWSDLFromProject(IProject project, ResourceSet resourceSet) {
        ArrayList<Definition> wsdlFiles = new ArrayList<Definition>();
        List<IFile> allFiles = DeployUtils.getAllFilesInProject(project);
        for (IFile file : allFiles) {
            if (!"wsdl".equalsIgnoreCase(file.getFileExtension())) continue;
            Definition currentDef = DeployUtils.loadWSDL(file, resourceSet);
            wsdlFiles.add(currentDef);
        }
        for (Resource res : resourceSet.getResources()) {
            Definition def;
            Object obj;
            EList contents = res.getContents();
            if (contents == null || contents.isEmpty() || !((obj = contents.get(0)) instanceof Definition) || wsdlFiles.contains(def = (Definition)obj)) continue;
            wsdlFiles.add(def);
        }
        return wsdlFiles;
    }

    public static List<Process> loadAllBPELFromProject(IProject project, ResourceSet resourceSet) {
        ArrayList<Process> bpelFiles = new ArrayList<Process>();
        List<IFile> allFiles = DeployUtils.getAllFilesInProject(project);
        for (IFile file : allFiles) {
            Process currentProcess;
            if (!DeployUtils.isBPELFile((IResource)file) || (currentProcess = DeployUtils.loadBPEL(file, resourceSet)) == null) continue;
            bpelFiles.add(currentProcess);
        }
        return bpelFiles;
    }

    public static List<IFile> getAllFilesInProject(IProject project) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    files.add((IFile)resource);
                }
                return true;
            }
        };
        try {
            IResource[] reses;
            IResource[] iResourceArray = reses = project.getFolder(DeployUtils.getWebContentRootPath(project)).members();
            int n = reses.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                res.accept(visitor);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static IFile getIFileForURI(URI uri) {
        if (uri == null) {
            return null;
        }
        String filePath = null;
        String scheme = uri.scheme();
        if (URL_PREFIX_FILE.equals(scheme)) {
            filePath = uri.toFileString();
        } else if (URL_PREFIX_PLATFORM.equals(scheme) && uri.segmentCount() > 1 && URL_PREFIX_RESOURCE.equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = uri.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(i));
                ++i;
            }
            filePath = URI.decode((String)platformResourcePath.toString());
        }
        if (filePath == null) {
            return null;
        }
        IFile file = null;
        if (URL_PREFIX_FILE.equals(scheme)) {
            if (uri.device() != null) {
                filePath = filePath.substring(filePath.indexOf(uri.device()));
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        } else {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        }
        return file;
    }

    public static boolean isBPELFile(IResource res) {
        try {
            IContentType type;
            IContentDescription desc;
            if (res.getType() == 1 && (desc = ((IFile)res).getContentDescription()) != null && (type = desc.getContentType()).getId().equals(BPEL_CONTENT_TYPE)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getProjectRelativePath();
        }
        return path;
    }
}

