/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.MultipleFormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.service.BusinessServices;
import org.uddi4j.transport.TransportException;

public class ManageReferencedServicesAction
extends UDDIPropertiesFormAction {
    protected String subQueryKey_ = null;
    protected boolean isSubQueryGet_ = false;
    protected String newSubQuery_;
    protected String newSubQueryItem_;
    protected boolean subQueryInitiated_ = false;
    protected RegistryNode regNode_ = this.getRegistryNode();

    public ManageReferencedServicesAction(Controller controller) {
        super(controller);
    }

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        this.newSubQuery_ = parser.getParameter("newSubQueryInitiated");
        String isSubQueryGetString = parser.getParameter("subQueryGet");
        this.newSubQueryItem_ = parser.getParameter("newSubQueryQueryItem");
        this.subQueryKey_ = parser.getParameter("subQueryKey");
        String[] referencedServicesCheckboxes = parser.getParameterValues("referencedServiceSelectState");
        String[] serviceNodeIds = parser.getParameterValues("nodeId_Service");
        String operation = parser.getParameter("managedReferencedServicesOperation");
        String publishURL = parser.getParameter("advancedPublishURL");
        String userId = parser.getParameter("advancedUserId");
        String password = parser.getParameter("advancedPassword");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formTool = this.getSelectedFormTool();
        FormToolPropertiesInterface formToolPI = ((MultipleFormToolPropertiesInterface)((Object)formTool)).getFormToolProperties(this.subQueryKey_);
        formToolPI.clearErrors();
        this.subQueryInitiated_ = this.newSubQuery_ != null && this.newSubQuery_.length() > 0;
        if (isSubQueryGetString != null) {
            this.isSubQueryGet_ = Boolean.valueOf(isSubQueryGetString);
        }
        if (operation != null) {
            this.propertyTable_.put("managedReferencedServicesOperation", operation);
        } else {
            this.removeProperty("managedReferencedServicesOperation");
        }
        if (referencedServicesCheckboxes != null) {
            this.propertyTable_.put("referencedServiceSelectState", referencedServicesCheckboxes);
        } else {
            this.removeProperty("referencedServiceSelectState");
        }
        if (serviceNodeIds != null) {
            Vector services = (Vector)formToolPI.getProperty("services");
            if (services == null) {
                services = new Vector();
            }
            Hashtable<String, Boolean> resultHash = new Hashtable<String, Boolean>();
            int i = 0;
            while (i < serviceNodeIds.length) {
                resultHash.put(serviceNodeIds[i], Boolean.TRUE);
                ++i;
            }
            i = 0;
            while (i < services.size()) {
                ListElement listElement = (ListElement)services.elementAt(i);
                if (resultHash.get(String.valueOf(listElement.getTargetNodeId())) == null) {
                    services.removeElementAt(i);
                    --i;
                }
                ++i;
            }
            this.propertyTable_.put("services", services);
        } else {
            this.removeProperty("services");
        }
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        if (!regElement.isLoggedIn()) {
            if (publishURL != null) {
                this.propertyTable_.put("advancedPublishURL", publishURL);
                formTool.setProperty("advancedPublishURL", publishURL);
            }
            if (!this.subQueryInitiated_ && !Validator.validateString(publishURL)) {
                inputsValid = false;
                formTool.flagError("advancedPublishURL");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_PUBLISH_URL"));
            }
            if (userId != null) {
                this.propertyTable_.put("advancedUserId", userId);
                formTool.setProperty("advancedUserId", userId);
            }
            if (!this.subQueryInitiated_ && !Validator.validateString(userId)) {
                inputsValid = false;
                formTool.flagError("advancedUserId");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USERID"));
            }
            if (password != null) {
                this.propertyTable_.put("advancedPassword", password);
                formTool.setProperty("advancedPassword", password);
            }
        }
        int i = 0;
        while (i < this.removedProperties_.size()) {
            formToolPI.removeProperty(this.removedProperties_.elementAt(i));
            ++i;
        }
        formToolPI.updatePropertyTable(this.propertyTable_);
        return inputsValid;
    }

    public boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        String operationString = (String)this.propertyTable_.get("managedReferencedServicesOperation");
        int operation = Integer.parseInt(operationString);
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        BusinessElement busElement = (BusinessElement)this.getSelectedNavigatorNode().getTreeElement();
        FormTool formTool = this.getSelectedFormTool();
        FormToolPropertiesInterface formToolPI = ((MultipleFormToolPropertiesInterface)((Object)formTool)).getFormToolProperties(this.subQueryKey_);
        Vector referencedServices = (Vector)formToolPI.getProperty("referencedServices");
        boolean operationResult = true;
        try {
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            UDDIProxy proxy = regElement.getProxy();
            BusinessEntity currentSP = busElement.getBusinessEntity();
            BusinessEntity sp = (BusinessEntity)proxy.get_businessDetail(currentSP.getBusinessKey()).getBusinessEntityVector().get(0);
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            Hashtable<String, BusinessService> servicesHash = new Hashtable<String, BusinessService>();
            Vector backupBusServiceVector = new Vector();
            switch (operation) {
                case 0: {
                    Vector services = (Vector)this.propertyTable_.get("services");
                    int i = 0;
                    while (i < services.size()) {
                        ListElement serviceListElement = (ListElement)services.elementAt(i);
                        BusinessService bs = (BusinessService)serviceListElement.getObject();
                        servicesHash.put(bs.getServiceKey(), bs);
                        ++i;
                    }
                    this.backupAndUpdateBusinessServices(backupBusServiceVector, sp, servicesHash, true);
                    try {
                        Vector<BusinessEntity> beVector = new Vector<BusinessEntity>();
                        beVector.add(sp);
                        sp = (BusinessEntity)proxy.save_business(regElement.getAuthInfoString(), beVector).getBusinessEntityVector().get(0);
                        int i2 = 0;
                        while (i2 < services.size()) {
                            ListElement serviceElement = (ListElement)services.elementAt(i2);
                            BusinessService bs = (BusinessService)serviceElement.getObject();
                            String bsName = bs.getDefaultNameString();
                            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_REFERENCED", bsName));
                            services.removeElementAt(i2);
                            --i2;
                            ++i2;
                        }
                    }
                    catch (TransportException e) {
                        this.rollbackBusinessServices(sp, backupBusServiceVector, services, uddiPerspective, messageQueue, "MSG_ERROR_SERVICE_NOT_REFERENCED");
                        this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
                        operationResult = false;
                    }
                    catch (UDDIException e) {
                        this.rollbackBusinessServices(sp, backupBusServiceVector, services, uddiPerspective, messageQueue, "MSG_ERROR_SERVICE_NOT_REFERENCED");
                        if (UDDIExceptionHandler.requiresReset(e)) {
                            regElement.setDefaults();
                        }
                        messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
                        messageQueue.addMessage("UDDIException");
                        messageQueue.addMessage(e.toString());
                        operationResult = false;
                    }
                    formToolPI.setProperty("services", services);
                    break;
                }
                case 1: {
                    String[] referencedServicesCheckboxes = (String[])this.propertyTable_.get("referencedServiceSelectState");
                    Vector<BusinessService> selectedReferencedServiceVector = new Vector<BusinessService>();
                    int i = 0;
                    while (i < referencedServicesCheckboxes.length) {
                        boolean isChecked = Boolean.valueOf(referencedServicesCheckboxes[i]);
                        if (isChecked) {
                            ListElement referencedServiceListElement = (ListElement)referencedServices.elementAt(i);
                            BusinessService bs = (BusinessService)referencedServiceListElement.getObject();
                            servicesHash.put(bs.getServiceKey(), bs);
                            selectedReferencedServiceVector.addElement(bs);
                        }
                        ++i;
                    }
                    this.backupAndUpdateBusinessServices(backupBusServiceVector, sp, servicesHash, false);
                    try {
                        Vector<BusinessEntity> beVector = new Vector<BusinessEntity>();
                        beVector.add(sp);
                        sp = (BusinessEntity)proxy.save_business(regElement.getAuthInfoString(), beVector).getBusinessEntityVector().get(0);
                        int i3 = 0;
                        while (i3 < selectedReferencedServiceVector.size()) {
                            BusinessService bs = (BusinessService)selectedReferencedServiceVector.elementAt(i3);
                            String bsName = bs.getDefaultNameString();
                            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_REFERENCE_REMOVED", bsName));
                            ++i3;
                        }
                        break;
                    }
                    catch (TransportException e) {
                        this.rollbackBusinessServices(sp, backupBusServiceVector, selectedReferencedServiceVector, uddiPerspective, messageQueue, "MSG_ERROR_REFERENCE_NOT_REMOVED");
                        this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
                        operationResult = false;
                        break;
                    }
                    catch (UDDIException e) {
                        this.rollbackBusinessServices(sp, backupBusServiceVector, selectedReferencedServiceVector, uddiPerspective, messageQueue, "MSG_ERROR_REFERENCE_NOT_REMOVED");
                        if (UDDIExceptionHandler.requiresReset(e)) {
                            regElement.setDefaults();
                        }
                        messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
                        messageQueue.addMessage("UDDIException");
                        messageQueue.addMessage(e.toString());
                        operationResult = false;
                    }
                }
            }
            formToolPI.removeProperty("referencedServices");
            busElement.setBusinessEntity(sp);
            return operationResult;
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
            operationResult = false;
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                regElement.setDefaults();
            }
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
            operationResult = false;
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
            operationResult = false;
        }
        return operationResult;
    }

    public final boolean isSubQueryInitiated() {
        return this.subQueryInitiated_;
    }

    public final boolean isSubQueryGet() {
        return this.isSubQueryGet_;
    }

    public final String getSubQueryKey() {
        return this.subQueryKey_;
    }

    public final String getNewSubQuery() {
        return this.newSubQuery_;
    }

    public final String getNewSubQueryItem() {
        return this.newSubQueryItem_;
    }

    private final void backupAndUpdateBusinessServices(Vector backupBusServiceVector, BusinessEntity be, Hashtable servicesHash, boolean isAdd) {
        BusinessServices currentBusServices = be.getBusinessServices();
        if (currentBusServices == null) {
            currentBusServices = new BusinessServices();
        }
        Vector currentBusServiceVector = currentBusServices.getBusinessServiceVector();
        int i = 0;
        while (i < currentBusServiceVector.size()) {
            BusinessService currentBusService = (BusinessService)currentBusServiceVector.elementAt(i);
            backupBusServiceVector.addElement(currentBusService);
            if (servicesHash.get(currentBusService.getServiceKey()) != null) {
                currentBusServiceVector.removeElementAt(i);
                --i;
            }
            ++i;
        }
        if (isAdd) {
            Enumeration e = servicesHash.elements();
            while (e.hasMoreElements()) {
                currentBusServiceVector.addElement((BusinessService)e.nextElement());
            }
        }
        be.setBusinessServices(currentBusServices);
    }

    private final void rollbackBusinessServices(BusinessEntity be, Vector backupBusServiceVector, Vector operatedServices, Perspective perspective, MessageQueue messageQueue, String errorMessageKey) {
        be.getBusinessServices().setBusinessServiceVector(backupBusServiceVector);
        int i = 0;
        while (i < operatedServices.size()) {
            ListElement serviceListElement = (ListElement)operatedServices.elementAt(i);
            BusinessService bs = (BusinessService)serviceListElement.getObject();
            String bsName = bs.getDefaultNameString();
            messageQueue.addMessage(perspective.getMessage(errorMessageKey, bsName));
            ++i;
        }
    }
}

